//=============================================================================
//  Keke_FreeAnime - フリーアニメ
// バージョン: 1.4.2
//=============================================================================
// Copyright (c) 2022 ケケー
// Released under the MIT license
// http://opensource.org/licenses/mit-license.php
//=============================================================================

/*:
 * @target MZ
 * @plugindesc パーティクルアニメの自由度を拡張する
 * @author ケケー
 * @url https://kekeelabo.com
 * 
 * @help
 * 【ver.1.4.2】
 * パーティクルアニメの自由度を拡張する
 * 
 * ● 特徴 ●
 *
 * ◎好きな位置にアニメを表示
 * ◎好きな対象に向かってアニメを移動
 * ◎アニメ表示レイヤーの変更。キャラより下に表示など
 * ◎アニメを複数発生、各自を移動、拡縮、回転など自在に改造
 * ◎アニメをキャラの向きに応じて滑らかに回転
 * ◎アニメのマップオブジェクト化
 * ◎アニメの背景エフェクト化
 * ◎アニメのズーム対応
 *
 *
 * ● 使い方 ●
 *
 * 【基本1】マップでアニメを表示
 * => プラグインコマンド → アニメ表示-マップ
 * ◎再生する「アニメファイル」と、
 * 　「表示・移動対象」(キャラ or マップ位置 or 画面位置)を設定する
 * ◎「表示対象」を複数設定した場合(キャラとマップ位置 など)は、
 *　その全てにアニメが表示される
 * ◎「表示キャラ」は , で区切って複数指定でき(リード, プリシア など)、
 * 　その全てにアニメが表示される
 * ◎「表示キャラ」で位置固定すると、そのキャラの位置にアニメ表示した後、
 * 　キャラが移動しても追わずその場に固定される
 * ◎「移動先」を設定するとそこに向かって移動する
 * ◎必要なら「アニメ設定」もする。様々な動作設定が可能
 * ◎「アニメ設定」にはコモンが使える(後述)
 * ◎各パラメータは ~ を使ってランダム設定できる
 * 　50~100 なら 50 から 100 の間のランダム
 * ◎&r を付けるとランダムで反転させられる
 * 　100&r なら 100 か -100 のランダム
 * ◎各パラメータは \v[変数番号] で変数使用できる
 * 　\v[10]なら 変数10番 を使用
 * ◎移動X・移動Y・各パラメータ変動は「動作文字での動作制御」が可能
 *　詳しくは後述
 *
 *
 * 【基本2】バトルでアニメを表示
 * => プラグインコマンド → アニメ表示-バトル
 * ◎基本的にマップの場合と同じ
 *
 *
 * 【基本3】アニメコモン
 * => プラグインパラメータ → アニメコモン登録
 * ◎アニメコモンとは、「アニメ設定」の共有データのこと
 * 　コモンを下敷きにすることで手軽にアニメ設定ができる
 * ◎まずはプラグインパラメータでアニメコモンを登録
 * 　そしてプラグインコマンドでアニメ表示をする際、
 * 　「コモン使用」に設定したコモン名を書くことで呼び出せる
 * ◎コモンを呼び出すと「アニメ設定」の下敷きとなる
 * 　「アニメ設定」で空欄の部分はコモンのデータが使われ、
 * 　入力した部分はそれが優先して使用される
 * 　コモンから変更する部分だけ入力すればいいということ
 * ◎コモンを使わなくてもいいのだが、基本的には使うことを推奨
 *　より手軽なアニメ設定が可能になるので
 *
 *
 * 【基本4】フリーアニメ・スキル
 * 　戦闘中、スキル・アイテム使用時にフリーアニメを再生できる
 * ◎設定のしかた
 * 　スキル・アイテムのメモ欄に
 * <フリーアニメ: アニメーションID, コモン名, 移動時間, ディレイ, 1回だけ>
 * 　※ウェイト・移動時間・1回だけ は省略可能
 * 例)
 * <フリーアニメ:  37, インパクト>
 * 　ID37 のアニメを アニメコモン『インパクト』 の動作で再生する
 * <フリーアニメ:  37, インパクト, 20~30>
 * 　(移動時間の例1)。上と同様のアニメを、スキル使用者から対象者へと、
 * 　20～30 フレームかけて移動させながら再生する
 * <フリーアニメ:  37, インパクト, -1>
 * 　(移動時間の例2)。上と同様のアニメを、スキル使用者を対象に再生する
 * <フリーアニメ:  37, インパクト, , 8>
 * 　(ウェイトの例)。上と同様のアニメを、8フレーム 待ってから再生する
 * <フリーアニメ:  37, インパクト, , , 1>
 * 　(1回だけの例)。上と同様のアニメを、そのアクション中に1回だけ再生する
 * 　
 *
 *
 * 【応用1】動作文字での動作制御
 * 　移動X・移動Y・各パーティくる変動の末尾に
 * ----------これらイージング系はいずれかひとつだけ
 *  e
 * 　イージングインアウト。ゆっくり-速い-ゆっくり。標準はこれ
 *  ei
 * 　イージングイン。ゆっくり-速い
 *  eo
 * 　イージングアウト。速い-ゆっくり
 *  tn
 * 　ターン。→←。進んで戻る
 *  cg
 * 　チャージ。←→→。少し戻ってから一気に進む。cg(**)で戻り幅が **倍
 *  fk
 * 　フック。→→←。一気に進んでから少し戻る。fk(**)で戻り幅が **倍
 *  cf
 * 　チャージフック。←→→←。チャージとフックの融合。cf(**)で戻り幅が **倍
 *  rd
 * 　ラウンド。→←←→。ぐるりと円を描く
 *  bk
 * 　バック。←。戻ってくる
 * ----------イージング系を表記しない場合は自動的にイージングインアウトになる
 * 例)
 * →拡大率　2
 * 　拡大率をイージングインアウトをかけながら 2倍 にする
 * →拡大率　2ei
 * 　拡大率をイージングインをかけながら 2倍 にする
 * →拡大率　2tn
 * 　拡大率を 2倍 にして、元に戻す
 * 移動X　100cg
 * 　左に 100ピクセル 戻った後、右に 200ピクセル 進む
 * 移動X　100cg(0.5)
 * 　左に 50ピクセル 戻った後、右に 150ピクセル 進む
 *
 *
 * 【注釈1】名前でのキャラ指定について
 * ◎語句を入力すると、
 * 　入力語句が名前+メモ欄に“含まれている”イベントを指定する
 * 　『zoom』なら、名前+メモ欄に zoom が含まれているイベント
 * ◎プレイヤー と入力すると プレイヤー を指定
 * ◎セルフ と入力すると、動作中のイベント自身 を指定
 * ◎フォロワー1 と入力すると 1番目 のフォロワーを指定。フォロワー2 なら 2番目
 * ◎乗り物1 と入力すると 1番目 の乗り物を指定。乗り物2 なら 2番目
 * ◎\v[***] と入力すると変数使用。\v[5] なら 変数5番 と置換される
 * ◎ , で区切ると複数指定。プリシア, リード ならプリシアとリード
 *
 *
 * 【注釈2】IDでのキャラ指定について
 * ◎数値を入力すると、イベントIDがその値のイベントを指定する
 * 　5なら、ID 5 のイベント
 * ◎-1 を入力すると プレイヤー を指定
 * ◎0 を入力すると、動作中のイベント自身 を指定
 * ◎-11 を入力すると 1番目 のフォロワーを指定。-12 なら 2番目
 * ◎-101 を入力すると 1番目 の乗り物を指定。-101 なら 2番目
 * ◎\v[***] と入力すると変数使用。\v[5] なら 変数5番 と置換される
 * ◎ , で区切ると複数指定。5, 7 なら 5 と 7
 * ◎ ~ でまとめて指定。5~7 なら 5 と 6 と 7
 *
 *
 * 【付属】サンプルアニメの作り方
 * プラグイン公開サイト『ケケーラボ』で見れる本プラグインの宣伝動画
 * そこで使われているアニメの作り方を解説する
 * まずそのまま作ってみて、それに手を加えていく中で要領を掴んでいくとよい
 *
 * ▪︎火炎放射
 * アニメ名 => 火炎放射 (何でもよい)
 * アニメファイル => 炎/単体1
 * 表示・移動対象 => 
 * 　表示対象
 * 　　表示キャラ-名前: プレイヤー (イベント名を入れるとそのイベントに表示)
 * アニメ設定 =>
 * 　再生回数: -1 (ループさせる)
 * 　移動
 * 　　移動X: -300
 * 　　移動Y: -100~100 (-100 から 100 の間のランダム値にしている)
 * コモン使用 => 放射
 *
 * ▪︎火炎放射(追尾ver)
 * アニメ名 => 火炎放射 (何でもよい)
 * アニメファイル => 炎/単体1
 * 表示・移動対象 => 
 * 　表示対象
 * 　　表示キャラ-名前: プレイヤー (イベント名を入れるとそのイベントに表示)
 * 　移動先
 * 　　移動時間: 20
 * 　　移動先キャラ-名前: (追尾させるイベントの名前を入れる)
 * 　　追尾モード: true (false だと大雑把な追尾となる)
 * アニメ設定 =>
 * 　再生回数: -1 (ループさせる)
 * 　移動
 * 　　移動Y: -100~100 (-100 から 100 の間のランダム値にしている)
 * コモン使用 => 放射
 *
 * ▪︎キャンドル
 * アニメ名 => キャンドル (何でもよい)
 * アニメファイル => 炎/単体1
 * 表示・移動対象 => 
 * 　表示対象
 * 　　表示マップX: 表示させたい位置のX座標
 * 　　表示マップY: 表示させたい位置のY座標
 * アニメ設定 =>
 * 　位置
 * 　　位置ずらしX: 適宜X位置を調整する。5 なら右に 5ピクセル ずれる
 * 　　位置ずらしY: 適宜Y位置を調整する。5 なら下に 5ピクセル ずれる
 * コモン使用 => ループ_2k
 *
 * ▪︎キラキラ
 * アニメ名 => キラキラ (何でもよい)
 * アニメファイル => 蘇生2
 * 表示・移動対象 => 
 * 　表示対象
 * 　　表示画面X: 800 (画面左端から 800ピクセル の位置に)
 * 　　表示画面Y: 30 (画面上端から 30ピクセル の位置に)
 * アニメ設定 =>
 * 　パーティクル設定
 * 　　拡大率Y: -100 (上下反転している)
 * 　　回転Z: -45 (傾けている)
 * コモン使用 => ループ_2k
 *
 * ▪︎アビスゲート
 * アニメ名 => アビスゲート (何でもよい)
 * アニメファイル => 闇/単体2
 * 表示・移動対象 => 
 * 　表示対象
 * 　　表示画面X: 408 (画面中央にしている)
 * 　　表示画面Y: 312 (画面中央にしている)
 * アニメ設定 =>
 * 　パーティクル設定
 * 　　拡大率Y: -100 (上下反転している)
 * 　　回転Z: -45 (傾けている)
 * コモン使用 => バック_2k
 *
 * ▪︎滝
 * アニメ名 => 滝 (何でもよい)
 * アニメファイル => 水/全体2
 * 表示・移動対象 => 
 * 　表示対象
 * 　　表示画面X: 408 (画面中央にしている)
 * 　　表示画面Y: 312 (画面中央にしている)
 * アニメ設定 =>
 * 　パーティクル設定
 * 　　拡大率X: 200
 * 　　拡大率Y: 150
 * コモン使用 => バック
 *
 * ▪︎花火
 * アニメ名 => 花火 (何でもよい)
 * アニメファイル => 無属性/単体2
 * 表示・移動対象 => 
 * 　表示対象
 * 　　表示画面X: 408 (画面中央にしている)
 * 　　表示画面Y: 700 (画面下の方)
 * アニメ設定 =>
 * 　移動
 * 　　移動時間: 60
 * 　　移動X: -100~100
 * 　　移動Y: -300~-600
 * 　パーティクル設定
 * 　　拡大率: 30~60
 * 　パーティクル変動
 * 　　変動時間: 60
 * 　　変動ディレイ: 30 (変動開始を 30フレーム 遅らせている)
 * 　　拡大率: *2eo (*2 は 2倍、eo はイージングアウト命令)
 * 　　回転X: 360~720
 * コモン使用 => バック_乱
 *
 *
 * ● 利用規約 ●
 * MITライセンスのもと、自由に使ってくれて大丈夫です
 *
 *
 *
 * Extend the freedom of particle animation
 *
 * ● Features ●
 *
 * ◎ Display the animation at your favorite position
 * ◎ Move the animation to your favorite target
 * ◎ Change animation display layer. Display below the character, etc.
 * ◎ Generate multiple animations, move, scale, rotate, etc.
 * ◎ Rotate the animation smoothly according
 *   to the direction of the character
 * ◎ Turning animation into a map object
 * ◎ Anime background effects
 * ◎ Animation zoom support
 *
 *
 * ● How to use ●
 *
 * [Basic 1] Display animation on the map
 * => Plugin Command → Animate-Map
 * ◎ The "animation file" to be played,
 *   Set the "display/movement target"
 *   (character or map position or screen position)
 * ◎ If you set multiple "display targets"
 *   (characters and map positions, etc.),
 *   Animation is displayed in all of them
 * ◎ Multiple characters can be specified by separating them with a ,
 *   (Reed, Priscilla, etc.),Animation is displayed in all of them
 * ◎ If you fix the position with "display character",
 *   after the animation is displayed at that character's position,
 *   Even if the character moves, it will be fixed in place without chasing
 * ◎ If you set a "destination", it will move towards it.
 * ◎ If necessary, "animation setting" is also done.
 *   Various operation settings are possible
 * ◎ Common can be used for "animation settings" (described later)
 * ◎ Each parameter can be set randomly using ~
 *   Random between 50 and 100 if 　50~100
 * ◎ Add &r to randomly flip
 *   If 100&r then 100 or -100 random
 * ◎ Each parameter can be used as a variable with \v[variable number]
 *   Use variable number 10 if \v[10]
 * ◎ Move X, Move Y, and each parameter variation can be
 *   "controlled by action characters"
 *   See below for details
 *
 *
 * [Basic 2] Show animation in battle
 * => plug-in command → show animation-battle
 * ◎ Basically same as map
 *
 *
 * [Basic 3] Anime Common
 * => Plugin parameter → Anime common registration
 * ◎ Anime common is the shared data of "animation settings"
 *   You can easily set animation by using Common as a base
 * ◎ First, register the anime common with the plug-in parameter
 *   And when displaying animation with a plug-in command,
 *   Can be called by writing the common name set in "Use common"
 * ◎ When you call Common, it becomes the underlay of "Anime Settings"
 *   Common data is used for blanks in "Anime settings",
 * 　The input part is used with priority
 *   It means that you only need to enter the part to be changed from common
 * ◎ You don't have to use Common, but basically it is recommended to use it.
 *   Since it will be possible to make animation settings more easily
 *
 *
 * [Basic 4] Free animation skills
 * During battle, free animation can be played when using skills/items
 * ◎ How to set
 *   In the skill/item memo field
 * <freeAnime: animation ID, common name, movement time, delay, only once>
 *   ※Wait, movement time, and only once can be omitted
 * example)
 * <freeAnime: 37, Impact>
 *   Play ID37's anime with his anime common "Impact" action
 * <freeAnime: 37, Impact, 20~30>
 *   (Travel time example 1). The same animation as above,
 *   from the skill user to the target, Play while moving over 20-30 frames
 * <freeAnime: 37, Impact, -1>
 *   (Travel time example 2). Play the same animation as above for skill users
 * <freeAnime: 37, Impact, , 8>
 *   (weight example). Wait 8 frames before playing the same animation as above
 * <freeAnime: 37, Impact, , , 1>
 *   (one-time example). Play an animation similar to the one above, 
 *   but only once during that action
 *
 *
 * [Applied 1] Motion control with action characters
 * At the end of movement X, movement Y, and each party's change
 * ---------- only one of these easing systems
 * e
 * 　Easing in/out. Slow-fast-slow. the standard is this
 * ei
 *   Easing in. slow-fast
 * eo
 *   Easing out. fast-slow
 * tn
 *   Turn. →←. willing to go back
 * cg
 *   Charge. ←→→.
 *   Backtrack a little and then move on. cg(**) returns width ** times
 * fk
 *   hook. →→←.
 *   Go forward and then back up a bit. Return width is ** times with fk(**)
 * cf
 *   Charge hook. ←→→←.
 *   Fusion of charge and hook. cf(**) returns width ** times
 * rd
 *   Round. →←←→. draw a circle around
 * bk
 *   Back. ←. Come back
 * ---------- If you do not indicate the easing system,
 *   it will automatically be easing in-out
 * example)
 * → Magnification 2
 *   Double the magnification while applying easing in and out
 * → Magnification rate 2ei
 *   Double the magnification while easing in
 * → Magnification rate　2tn
 *   Double the magnification and restore
 * Movement X 100cg
 *   Go back 100 pixels to the left, then go 200 pixels to the right
 * Movement X 100cg (0.5)
 *   Go back 50 pixels to the left, then go 150 pixels to the right
 *
 *
 * [Note 1] About character designation by name
 * ◎ When you enter a word,
 *   Specify events where the input phrase is "included"
 *   in the name + memo field
 *   For "zoom", events that include "zoom" in the name + memo field
 * ◎ When you type player, he specifies the player
 * ◎ When you enter self, specify the event itself in action.
 * ◎ Enter follower 1 to specify the first follower. 2nd follower
 * ◎ Enter vehicle 1 to specify the first vehicle. 2nd if vehicle 2
 * ◎ Enter \v[***] to use variables. \v[5] is replaced with variable number 5
 * ◎ Multiple specifications can be specified by delimiting with,
 *   Priscilla, Reed If Priscilla and Reed
 *
 *
 * [Note 2] Regarding character designation by ID
 * ◎If you enter a number, the event ID specifies the event with that value.
 *   If 　5, the event with ID 5
 *   Enter ◎-1 and he will specify a player
 * ◎Entering 0 specifies the active event itself.
 *   Enter ◎-11 to specify the first follower. -12 is second
 *   Enter ◎-101 to specify the first ride. -101 is second
 * ◎ Enter \v[***] to use variables. \v[5] is replaced with variable number 5
 * ◎ Multiple specifications can be specified by delimiting with,
 *   5, 7 then 5 and 7
 * ◎ Specified collectively with ~. 5~7 then 5 and 6 and 7
 *
 *
 * ● Terms of Use ●
 * Feel free to use it under the MIT license.
 * 
 * 
 * 
 * @param アニメコモン登録
 * @desc アニメ設定をコモンとして登録しておき、必要に応じて呼び出す。アニメコモン1～も同じ。どれを使ってもよい
 * @type struct<animeCommon>[]
 * @default 
 * 
 * 
 * 
 * @param アニメコモン_1
 * @parent アニメコモン登録
 * @desc アニメコモンその1。どれを使ってもよい
 * @type struct<animeCommon>[]
 * @default ["{\"コモン名\":\"■基本\",\"再生回数\":\"1\",\"開始ウェイト\":\"0\",\"中間ウェイト\":\"0\",\"レイヤー\":\"B1\",\"ズーム対応\":\"true\",\"表示範囲\":\"0\",\"位置\":\"\",\"位置ずらしX\":\"0\",\"位置ずらしY\":\"0\",\"発生\":\"\",\"発生数\":\"1\",\"発生ルート\":\"[]\",\"発生ずらしX\":\"0\",\"発生ずらしY\":\"0\",\"最初は初期位置\":\"false\",\"発生ディレイ\":\"0\",\"移動\":\"\",\"移動時間\":\"20\",\"移動ディレイ\":\"0\",\"移動X\":\"0\",\"移動Y\":\"0\",\"移動リセットX\":\"true\",\"移動リセットY\":\"true\",\"パーティクル設定\":\"\",\"拡大率\":\"\",\"拡大率X\":\"\",\"拡大率Y\":\"\",\"拡大率Z\":\"\",\"回転X\":\"\",\"回転Y\":\"\",\"回転Z\":\"\",\"速度\":\"\",\"オフセットX\":\"\",\"オフセットY\":\"\",\"下揃え\":\"false\",\"効果音-音量率\":\"\",\"効果音-ピッチ率\":\"\",\"フラッシュなし\":\"false\",\"効果音なし\":\"false\",\"パーティクル変動\":\"\",\"変動時間\":\"20\",\"変動ディレイ\":\"0\",\"→拡大率\":\"\",\"→拡大率X\":\"\",\"→拡大率Y\":\"\",\"→拡大率Z\":\"\",\"→回転X\":\"\",\"→回転Y\":\"\",\"→回転Z\":\"\",\"向き対応\":\"\",\"向き回転X\":\"false\",\"向き回転Y\":\"false\",\"向き回転R\":\"false\",\"回転時間\":\"15\",\"特殊効果\":\"\",\"画面ストップ\":\"0, 0\"}","{\"コモン名\":\"ノーマル\",\"再生回数\":\"1\",\"開始ウェイト\":\"\",\"中間ウェイト\":\"\",\"レイヤー\":\"B1\",\"ズーム対応\":\"true\",\"表示範囲\":\"\",\"位置\":\"\",\"位置ずらしX\":\"\",\"位置ずらしY\":\"\",\"発生\":\"\",\"発生数\":\"1\",\"発生ルート\":\"\",\"発生ずらしX\":\"\",\"発生ずらしY\":\"\",\"最初は初期位置\":\"\",\"発生ディレイ\":\"\",\"移動\":\"\",\"移動時間\":\"20\",\"移動ディレイ\":\"\",\"移動X\":\"\",\"移動Y\":\"\",\"移動リセットX\":\"true\",\"移動リセットY\":\"true\",\"パーティクル設定\":\"\",\"拡大率\":\"\",\"拡大率X\":\"\",\"拡大率Y\":\"\",\"拡大率Z\":\"\",\"回転X\":\"\",\"回転Y\":\"\",\"回転Z\":\"\",\"速度\":\"\",\"オフセットX\":\"\",\"オフセットY\":\"\",\"下揃え\":\"\",\"効果音-音量率\":\"\",\"効果音-ピッチ率\":\"\",\"フラッシュなし\":\"\",\"効果音なし\":\"\",\"パーティクル変動\":\"\",\"変動時間\":\"20\",\"変動ディレイ\":\"\",\"→拡大率\":\"\",\"→拡大率X\":\"\",\"→拡大率Y\":\"\",\"→拡大率Z\":\"\",\"→回転X\":\"\",\"→回転Y\":\"\",\"→回転Z\":\"\",\"向き対応\":\"\",\"向き回転X\":\"true\",\"向き回転Y\":\"true\",\"向き回転R\":\"\",\"回転時間\":\"15\",\"特殊効果\":\"\",\"画面ストップ\":\"0, 0\"}","{\"コモン名\":\"スピード\",\"再生回数\":\"1\",\"開始ウェイト\":\"\",\"中間ウェイト\":\"\",\"レイヤー\":\"B1\",\"ズーム対応\":\"true\",\"表示範囲\":\"\",\"位置\":\"\",\"位置ずらしX\":\"\",\"位置ずらしY\":\"\",\"発生\":\"\",\"発生数\":\"1\",\"発生ルート\":\"\",\"発生ずらしX\":\"\",\"発生ずらしY\":\"\",\"最初は初期位置\":\"\",\"発生ディレイ\":\"\",\"移動\":\"\",\"移動時間\":\"20\",\"移動ディレイ\":\"\",\"移動X\":\"\",\"移動Y\":\"\",\"移動リセットX\":\"true\",\"移動リセットY\":\"true\",\"パーティクル設定\":\"\",\"拡大率\":\"\",\"拡大率X\":\"\",\"拡大率Y\":\"\",\"拡大率Z\":\"\",\"回転X\":\"\",\"回転Y\":\"\",\"回転Z\":\"\",\"速度\":\"200\",\"オフセットX\":\"\",\"オフセットY\":\"\",\"下揃え\":\"\",\"効果音-音量率\":\"\",\"効果音-ピッチ率\":\"\",\"フラッシュなし\":\"\",\"効果音なし\":\"\",\"パーティクル変動\":\"\",\"変動時間\":\"20\",\"変動ディレイ\":\"\",\"→拡大率\":\"\",\"→拡大率X\":\"\",\"→拡大率Y\":\"\",\"→拡大率Z\":\"\",\"→回転X\":\"\",\"→回転Y\":\"\",\"→回転Z\":\"\",\"向き対応\":\"\",\"向き回転X\":\"true\",\"向き回転Y\":\"true\",\"向き回転R\":\"\",\"回転時間\":\"15\",\"特殊効果\":\"\",\"画面ストップ\":\"0, 0\"}","{\"コモン名\":\"スピード-小\",\"再生回数\":\"1\",\"開始ウェイト\":\"\",\"中間ウェイト\":\"\",\"レイヤー\":\"B1\",\"ズーム対応\":\"true\",\"表示範囲\":\"\",\"位置\":\"\",\"位置ずらしX\":\"\",\"位置ずらしY\":\"\",\"発生\":\"\",\"発生数\":\"1\",\"発生ルート\":\"\",\"発生ずらしX\":\"\",\"発生ずらしY\":\"\",\"最初は初期位置\":\"\",\"発生ディレイ\":\"\",\"移動\":\"\",\"移動時間\":\"20\",\"移動ディレイ\":\"\",\"移動X\":\"\",\"移動Y\":\"\",\"移動リセットX\":\"true\",\"移動リセットY\":\"true\",\"パーティクル設定\":\"\",\"拡大率\":\"75\",\"拡大率X\":\"\",\"拡大率Y\":\"\",\"拡大率Z\":\"\",\"回転X\":\"\",\"回転Y\":\"\",\"回転Z\":\"\",\"速度\":\"200\",\"オフセットX\":\"\",\"オフセットY\":\"\",\"下揃え\":\"\",\"効果音-音量率\":\"\",\"効果音-ピッチ率\":\"\",\"フラッシュなし\":\"\",\"効果音なし\":\"\",\"パーティクル変動\":\"\",\"変動時間\":\"20\",\"変動ディレイ\":\"\",\"→拡大率\":\"\",\"→拡大率X\":\"\",\"→拡大率Y\":\"\",\"→拡大率Z\":\"\",\"→回転X\":\"\",\"→回転Y\":\"\",\"→回転Z\":\"\",\"向き対応\":\"\",\"向き回転X\":\"true\",\"向き回転Y\":\"true\",\"向き回転R\":\"\",\"回転時間\":\"15\",\"特殊効果\":\"\",\"画面ストップ\":\"0, 0\"}","{\"コモン名\":\"ハイスピード\",\"再生回数\":\"1\",\"開始ウェイト\":\"\",\"中間ウェイト\":\"\",\"レイヤー\":\"B1\",\"ズーム対応\":\"true\",\"表示範囲\":\"\",\"位置\":\"\",\"位置ずらしX\":\"\",\"位置ずらしY\":\"\",\"発生\":\"\",\"発生数\":\"1\",\"発生ルート\":\"\",\"発生ずらしX\":\"\",\"発生ずらしY\":\"\",\"最初は初期位置\":\"\",\"発生ディレイ\":\"\",\"移動\":\"\",\"移動時間\":\"20\",\"移動ディレイ\":\"\",\"移動X\":\"\",\"移動Y\":\"\",\"移動リセットX\":\"true\",\"移動リセットY\":\"true\",\"パーティクル設定\":\"\",\"拡大率\":\"\",\"拡大率X\":\"\",\"拡大率Y\":\"\",\"拡大率Z\":\"\",\"回転X\":\"\",\"回転Y\":\"\",\"回転Z\":\"\",\"速度\":\"400\",\"オフセットX\":\"\",\"オフセットY\":\"\",\"下揃え\":\"\",\"効果音-音量率\":\"\",\"効果音-ピッチ率\":\"\",\"フラッシュなし\":\"\",\"効果音なし\":\"\",\"パーティクル変動\":\"\",\"変動時間\":\"20\",\"変動ディレイ\":\"\",\"→拡大率\":\"\",\"→拡大率X\":\"\",\"→拡大率Y\":\"\",\"→拡大率Z\":\"\",\"→回転X\":\"\",\"→回転Y\":\"\",\"→回転Z\":\"\",\"向き対応\":\"\",\"向き回転X\":\"true\",\"向き回転Y\":\"true\",\"向き回転R\":\"\",\"回転時間\":\"15\",\"特殊効果\":\"\",\"画面ストップ\":\"0, 0\"}","{\"コモン名\":\"スロウ\",\"再生回数\":\"1\",\"開始ウェイト\":\"\",\"中間ウェイト\":\"\",\"レイヤー\":\"B1\",\"ズーム対応\":\"true\",\"表示範囲\":\"\",\"位置\":\"\",\"位置ずらしX\":\"\",\"位置ずらしY\":\"\",\"発生\":\"\",\"発生数\":\"1\",\"発生ルート\":\"\",\"発生ずらしX\":\"\",\"発生ずらしY\":\"\",\"最初は初期位置\":\"\",\"発生ディレイ\":\"\",\"移動\":\"\",\"移動時間\":\"20\",\"移動ディレイ\":\"\",\"移動X\":\"\",\"移動Y\":\"\",\"移動リセットX\":\"true\",\"移動リセットY\":\"true\",\"パーティクル設定\":\"\",\"拡大率\":\"\",\"拡大率X\":\"\",\"拡大率Y\":\"\",\"拡大率Z\":\"\",\"回転X\":\"\",\"回転Y\":\"\",\"回転Z\":\"\",\"速度\":\"50\",\"オフセットX\":\"\",\"オフセットY\":\"\",\"下揃え\":\"\",\"効果音-音量率\":\"\",\"効果音-ピッチ率\":\"\",\"フラッシュなし\":\"\",\"効果音なし\":\"\",\"パーティクル変動\":\"\",\"変動時間\":\"20\",\"変動ディレイ\":\"\",\"→拡大率\":\"\",\"→拡大率X\":\"\",\"→拡大率Y\":\"\",\"→拡大率Z\":\"\",\"→回転X\":\"\",\"→回転Y\":\"\",\"→回転Z\":\"\",\"向き対応\":\"\",\"向き回転X\":\"true\",\"向き回転Y\":\"true\",\"向き回転R\":\"\",\"回転時間\":\"15\",\"特殊効果\":\"\",\"画面ストップ\":\"0, 0\"}","{\"コモン名\":\"ビッグ\",\"再生回数\":\"1\",\"開始ウェイト\":\"\",\"中間ウェイト\":\"\",\"レイヤー\":\"B1\",\"ズーム対応\":\"true\",\"表示範囲\":\"\",\"位置\":\"\",\"位置ずらしX\":\"\",\"位置ずらしY\":\"\",\"発生\":\"\",\"発生数\":\"1\",\"発生ルート\":\"\",\"発生ずらしX\":\"\",\"発生ずらしY\":\"\",\"最初は初期位置\":\"\",\"発生ディレイ\":\"\",\"移動\":\"\",\"移動時間\":\"20\",\"移動ディレイ\":\"\",\"移動X\":\"\",\"移動Y\":\"\",\"移動リセットX\":\"true\",\"移動リセットY\":\"true\",\"パーティクル設定\":\"\",\"拡大率\":\"\",\"拡大率X\":\"150\",\"拡大率Y\":\"150\",\"拡大率Z\":\"\",\"回転X\":\"\",\"回転Y\":\"\",\"回転Z\":\"\",\"速度\":\"\",\"オフセットX\":\"\",\"オフセットY\":\"\",\"下揃え\":\"\",\"効果音-音量率\":\"\",\"効果音-ピッチ率\":\"\",\"フラッシュなし\":\"false\",\"効果音なし\":\"false\",\"パーティクル変動\":\"\",\"変動時間\":\"20\",\"変動ディレイ\":\"\",\"→拡大率\":\"\",\"→拡大率X\":\"\",\"→拡大率Y\":\"\",\"→拡大率Z\":\"\",\"→回転X\":\"\",\"→回転Y\":\"\",\"→回転Z\":\"\",\"向き対応\":\"\",\"向き回転X\":\"true\",\"向き回転Y\":\"true\",\"向き回転R\":\"\",\"回転時間\":\"15\",\"特殊効果\":\"\",\"画面ストップ\":\"0, 0\"}","{\"コモン名\":\"ミニマム\",\"再生回数\":\"1\",\"開始ウェイト\":\"\",\"中間ウェイト\":\"\",\"レイヤー\":\"B1\",\"ズーム対応\":\"true\",\"表示範囲\":\"\",\"位置\":\"\",\"位置ずらしX\":\"\",\"位置ずらしY\":\"\",\"発生\":\"\",\"発生数\":\"1\",\"発生ルート\":\"\",\"発生ずらしX\":\"\",\"発生ずらしY\":\"\",\"最初は初期位置\":\"\",\"発生ディレイ\":\"\",\"移動\":\"\",\"移動時間\":\"20\",\"移動ディレイ\":\"\",\"移動X\":\"\",\"移動Y\":\"\",\"移動リセットX\":\"true\",\"移動リセットY\":\"true\",\"パーティクル設定\":\"\",\"拡大率\":\"50\",\"拡大率X\":\"\",\"拡大率Y\":\"\",\"拡大率Z\":\"\",\"回転X\":\"\",\"回転Y\":\"\",\"回転Z\":\"\",\"速度\":\"200\",\"オフセットX\":\"\",\"オフセットY\":\"\",\"下揃え\":\"\",\"効果音-音量率\":\"\",\"効果音-ピッチ率\":\"\",\"フラッシュなし\":\"\",\"効果音なし\":\"\",\"パーティクル変動\":\"\",\"変動時間\":\"20\",\"変動ディレイ\":\"\",\"→拡大率\":\"\",\"→拡大率X\":\"\",\"→拡大率Y\":\"\",\"→拡大率Z\":\"\",\"→回転X\":\"\",\"→回転Y\":\"\",\"→回転Z\":\"\",\"向き対応\":\"\",\"向き回転X\":\"true\",\"向き回転Y\":\"true\",\"向き回転R\":\"\",\"回転時間\":\"15\",\"特殊効果\":\"\",\"画面ストップ\":\"0, 0\"}","{\"コモン名\":\"ミニマム-大\",\"再生回数\":\"1\",\"開始ウェイト\":\"\",\"中間ウェイト\":\"\",\"レイヤー\":\"B1\",\"ズーム対応\":\"true\",\"表示範囲\":\"\",\"位置\":\"\",\"位置ずらしX\":\"\",\"位置ずらしY\":\"\",\"発生\":\"\",\"発生数\":\"1\",\"発生ルート\":\"\",\"発生ずらしX\":\"\",\"発生ずらしY\":\"\",\"最初は初期位置\":\"\",\"発生ディレイ\":\"\",\"移動\":\"\",\"移動時間\":\"20\",\"移動ディレイ\":\"\",\"移動X\":\"\",\"移動Y\":\"\",\"移動リセットX\":\"true\",\"移動リセットY\":\"true\",\"パーティクル設定\":\"\",\"拡大率\":\"70\",\"拡大率X\":\"\",\"拡大率Y\":\"\",\"拡大率Z\":\"\",\"回転X\":\"\",\"回転Y\":\"\",\"回転Z\":\"\",\"速度\":\"200\",\"オフセットX\":\"\",\"オフセットY\":\"\",\"下揃え\":\"\",\"効果音-音量率\":\"\",\"効果音-ピッチ率\":\"\",\"フラッシュなし\":\"\",\"効果音なし\":\"\",\"パーティクル変動\":\"\",\"変動時間\":\"20\",\"変動ディレイ\":\"\",\"→拡大率\":\"\",\"→拡大率X\":\"\",\"→拡大率Y\":\"\",\"→拡大率Z\":\"\",\"→回転X\":\"\",\"→回転Y\":\"\",\"→回転Z\":\"\",\"向き対応\":\"\",\"向き回転X\":\"true\",\"向き回転Y\":\"true\",\"向き回転R\":\"\",\"回転時間\":\"15\",\"特殊効果\":\"\",\"画面ストップ\":\"0, 0\"}","{\"コモン名\":\"スピン\",\"再生回数\":\"1\",\"開始ウェイト\":\"\",\"中間ウェイト\":\"\",\"レイヤー\":\"B1\",\"ズーム対応\":\"true\",\"表示範囲\":\"\",\"位置\":\"\",\"位置ずらしX\":\"\",\"位置ずらしY\":\"\",\"発生\":\"\",\"発生数\":\"1\",\"発生ルート\":\"\",\"発生ずらしX\":\"\",\"発生ずらしY\":\"\",\"最初は初期位置\":\"\",\"発生ディレイ\":\"\",\"移動\":\"\",\"移動時間\":\"20\",\"移動ディレイ\":\"\",\"移動X\":\"\",\"移動Y\":\"\",\"移動リセットX\":\"true\",\"移動リセットY\":\"true\",\"パーティクル設定\":\"\",\"拡大率\":\"\",\"拡大率X\":\"\",\"拡大率Y\":\"\",\"拡大率Z\":\"\",\"回転X\":\"\",\"回転Y\":\"\",\"回転Z\":\"\",\"速度\":\"\",\"オフセットX\":\"\",\"オフセットY\":\"\",\"下揃え\":\"\",\"効果音-音量率\":\"\",\"効果音-ピッチ率\":\"\",\"フラッシュなし\":\"\",\"効果音なし\":\"\",\"パーティクル変動\":\"\",\"変動時間\":\"30\",\"変動ディレイ\":\"\",\"→拡大率\":\"\",\"→拡大率X\":\"\",\"→拡大率Y\":\"\",\"→拡大率Z\":\"\",\"→回転X\":\"1080\",\"→回転Y\":\"\",\"→回転Z\":\"\",\"向き対応\":\"\",\"向き回転X\":\"true\",\"向き回転Y\":\"true\",\"向き回転R\":\"\",\"回転時間\":\"15\",\"特殊効果\":\"\",\"画面ストップ\":\"0, 0\"}","{\"コモン名\":\"スピン-小\",\"再生回数\":\"1\",\"開始ウェイト\":\"\",\"中間ウェイト\":\"\",\"レイヤー\":\"B1\",\"ズーム対応\":\"true\",\"表示範囲\":\"\",\"位置\":\"\",\"位置ずらしX\":\"\",\"位置ずらしY\":\"\",\"発生\":\"\",\"発生数\":\"1\",\"発生ルート\":\"\",\"発生ずらしX\":\"\",\"発生ずらしY\":\"\",\"最初は初期位置\":\"\",\"発生ディレイ\":\"\",\"移動\":\"\",\"移動時間\":\"20\",\"移動ディレイ\":\"\",\"移動X\":\"\",\"移動Y\":\"\",\"移動リセットX\":\"true\",\"移動リセットY\":\"true\",\"パーティクル設定\":\"\",\"拡大率\":\"80\",\"拡大率X\":\"\",\"拡大率Y\":\"\",\"拡大率Z\":\"\",\"回転X\":\"\",\"回転Y\":\"\",\"回転Z\":\"\",\"速度\":\"200\",\"オフセットX\":\"\",\"オフセットY\":\"\",\"下揃え\":\"\",\"効果音-音量率\":\"\",\"効果音-ピッチ率\":\"\",\"フラッシュなし\":\"\",\"効果音なし\":\"\",\"パーティクル変動\":\"\",\"変動時間\":\"60\",\"変動ディレイ\":\"\",\"→拡大率\":\"\",\"→拡大率X\":\"\",\"→拡大率Y\":\"\",\"→拡大率Z\":\"\",\"→回転X\":\"2160\",\"→回転Y\":\"\",\"→回転Z\":\"\",\"向き対応\":\"\",\"向き回転X\":\"true\",\"向き回転Y\":\"true\",\"向き回転R\":\"\",\"回転時間\":\"15\",\"特殊効果\":\"\",\"画面ストップ\":\"0, 0\"}","{\"コモン名\":\"ハイスピン\",\"再生回数\":\"1\",\"開始ウェイト\":\"\",\"中間ウェイト\":\"\",\"レイヤー\":\"B1\",\"ズーム対応\":\"true\",\"表示範囲\":\"\",\"位置\":\"\",\"位置ずらしX\":\"\",\"位置ずらしY\":\"\",\"発生\":\"\",\"発生数\":\"1\",\"発生ルート\":\"\",\"発生ずらしX\":\"\",\"発生ずらしY\":\"\",\"最初は初期位置\":\"\",\"発生ディレイ\":\"\",\"移動\":\"\",\"移動時間\":\"20\",\"移動ディレイ\":\"\",\"移動X\":\"\",\"移動Y\":\"\",\"移動リセットX\":\"true\",\"移動リセットY\":\"true\",\"パーティクル設定\":\"\",\"拡大率\":\"\",\"拡大率X\":\"\",\"拡大率Y\":\"\",\"拡大率Z\":\"\",\"回転X\":\"\",\"回転Y\":\"\",\"回転Z\":\"\",\"速度\":\"\",\"オフセットX\":\"\",\"オフセットY\":\"\",\"下揃え\":\"\",\"効果音-音量率\":\"\",\"効果音-ピッチ率\":\"\",\"フラッシュなし\":\"\",\"効果音なし\":\"\",\"パーティクル変動\":\"\",\"変動時間\":\"30\",\"変動ディレイ\":\"\",\"→拡大率\":\"\",\"→拡大率X\":\"\",\"→拡大率Y\":\"\",\"→拡大率Z\":\"\",\"→回転X\":\"1800\",\"→回転Y\":\"1800\",\"→回転Z\":\"1800\",\"向き対応\":\"\",\"向き回転X\":\"true\",\"向き回転Y\":\"true\",\"向き回転R\":\"\",\"回転時間\":\"15\",\"特殊効果\":\"\",\"画面ストップ\":\"0, 0\"}","{\"コモン名\":\"ランダム\",\"再生回数\":\"1\",\"開始ウェイト\":\"\",\"中間ウェイト\":\"\",\"レイヤー\":\"B1\",\"ズーム対応\":\"true\",\"表示範囲\":\"\",\"位置\":\"\",\"位置ずらしX\":\"\",\"位置ずらしY\":\"\",\"発生\":\"\",\"発生数\":\"1\",\"発生ルート\":\"\",\"発生ずらしX\":\"\",\"発生ずらしY\":\"\",\"最初は初期位置\":\"\",\"発生ディレイ\":\"\",\"移動\":\"\",\"移動時間\":\"20\",\"移動ディレイ\":\"\",\"移動X\":\"\",\"移動Y\":\"\",\"移動リセットX\":\"true\",\"移動リセットY\":\"true\",\"パーティクル設定\":\"\",\"拡大率\":\"\",\"拡大率X\":\"100&r\",\"拡大率Y\":\"100&r\",\"拡大率Z\":\"100&r\",\"回転X\":\"\",\"回転Y\":\"\",\"回転Z\":\"\",\"速度\":\"\",\"オフセットX\":\"\",\"オフセットY\":\"\",\"下揃え\":\"\",\"効果音-音量率\":\"\",\"効果音-ピッチ率\":\"\",\"フラッシュなし\":\"\",\"効果音なし\":\"\",\"パーティクル変動\":\"\",\"変動時間\":\"20\",\"変動ディレイ\":\"\",\"→拡大率\":\"\",\"→拡大率X\":\"\",\"→拡大率Y\":\"\",\"→拡大率Z\":\"\",\"→回転X\":\"\",\"→回転Y\":\"\",\"→回転Z\":\"\",\"向き対応\":\"\",\"向き回転X\":\"true\",\"向き回転Y\":\"true\",\"向き回転R\":\"\",\"回転時間\":\"15\",\"特殊効果\":\"\",\"画面ストップ\":\"0, 0\"}","{\"コモン名\":\"ランダム-小\",\"再生回数\":\"1\",\"開始ウェイト\":\"\",\"中間ウェイト\":\"\",\"レイヤー\":\"B1\",\"ズーム対応\":\"true\",\"表示範囲\":\"\",\"位置\":\"\",\"位置ずらしX\":\"\",\"位置ずらしY\":\"\",\"発生\":\"\",\"発生数\":\"1\",\"発生ルート\":\"\",\"発生ずらしX\":\"\",\"発生ずらしY\":\"\",\"最初は初期位置\":\"\",\"発生ディレイ\":\"\",\"移動\":\"\",\"移動時間\":\"20\",\"移動ディレイ\":\"\",\"移動X\":\"\",\"移動Y\":\"\",\"移動リセットX\":\"true\",\"移動リセットY\":\"true\",\"パーティクル設定\":\"\",\"拡大率\":\"\",\"拡大率X\":\"50&r\",\"拡大率Y\":\"50&r\",\"拡大率Z\":\"50&r\",\"回転X\":\"\",\"回転Y\":\"\",\"回転Z\":\"\",\"速度\":\"\",\"オフセットX\":\"\",\"オフセットY\":\"\",\"下揃え\":\"\",\"効果音-音量率\":\"\",\"効果音-ピッチ率\":\"\",\"フラッシュなし\":\"\",\"効果音なし\":\"\",\"パーティクル変動\":\"\",\"変動時間\":\"20\",\"変動ディレイ\":\"\",\"→拡大率\":\"\",\"→拡大率X\":\"\",\"→拡大率Y\":\"\",\"→拡大率Z\":\"\",\"→回転X\":\"\",\"→回転Y\":\"\",\"→回転Z\":\"\",\"向き対応\":\"\",\"向き回転X\":\"true\",\"向き回転Y\":\"true\",\"向き回転R\":\"\",\"回転時間\":\"15\",\"特殊効果\":\"\",\"画面ストップ\":\"0, 0\"}","{\"コモン名\":\"ランダム位置\",\"再生回数\":\"1\",\"開始ウェイト\":\"\",\"中間ウェイト\":\"\",\"レイヤー\":\"B1\",\"ズーム対応\":\"true\",\"表示範囲\":\"\",\"位置\":\"\",\"位置ずらしX\":\"\",\"位置ずらしY\":\"\",\"発生\":\"\",\"発生数\":\"1\",\"発生ルート\":\"\",\"発生ずらしX\":\"\",\"発生ずらしY\":\"\",\"最初は初期位置\":\"\",\"発生ディレイ\":\"\",\"移動\":\"\",\"移動時間\":\"20\",\"移動ディレイ\":\"\",\"移動X\":\"\",\"移動Y\":\"\",\"移動リセットX\":\"true\",\"移動リセットY\":\"true\",\"パーティクル設定\":\"\",\"拡大率\":\"\",\"拡大率X\":\"100&r\",\"拡大率Y\":\"100&r\",\"拡大率Z\":\"100&r\",\"回転X\":\"\",\"回転Y\":\"\",\"回転Z\":\"\",\"速度\":\"\",\"オフセットX\":\"-100~100\",\"オフセットY\":\"-100~100\",\"下揃え\":\"\",\"効果音-音量率\":\"\",\"効果音-ピッチ率\":\"\",\"フラッシュなし\":\"\",\"効果音なし\":\"\",\"パーティクル変動\":\"\",\"変動時間\":\"20\",\"変動ディレイ\":\"\",\"→拡大率\":\"\",\"→拡大率X\":\"\",\"→拡大率Y\":\"\",\"→拡大率Z\":\"\",\"→回転X\":\"\",\"→回転Y\":\"\",\"→回転Z\":\"\",\"向き対応\":\"\",\"向き回転X\":\"true\",\"向き回転Y\":\"true\",\"向き回転R\":\"\",\"回転時間\":\"15\",\"特殊効果\":\"\",\"画面ストップ\":\"0, 0\"}","{\"コモン名\":\"サイレント\",\"再生回数\":\"1\",\"開始ウェイト\":\"\",\"中間ウェイト\":\"\",\"レイヤー\":\"B1\",\"ズーム対応\":\"true\",\"表示範囲\":\"\",\"位置\":\"\",\"位置ずらしX\":\"\",\"位置ずらしY\":\"\",\"発生\":\"\",\"発生数\":\"1\",\"発生ルート\":\"\",\"発生ずらしX\":\"\",\"発生ずらしY\":\"\",\"最初は初期位置\":\"\",\"発生ディレイ\":\"\",\"移動\":\"\",\"移動時間\":\"20\",\"移動ディレイ\":\"\",\"移動X\":\"\",\"移動Y\":\"\",\"移動リセットX\":\"true\",\"移動リセットY\":\"true\",\"パーティクル設定\":\"\",\"拡大率\":\"\",\"拡大率X\":\"\",\"拡大率Y\":\"\",\"拡大率Z\":\"\",\"回転X\":\"\",\"回転Y\":\"\",\"回転Z\":\"\",\"速度\":\"\",\"オフセットX\":\"\",\"オフセットY\":\"\",\"下揃え\":\"\",\"効果音-音量率\":\"\",\"効果音-ピッチ率\":\"\",\"フラッシュなし\":\"\",\"効果音なし\":\"true\",\"パーティクル変動\":\"\",\"変動時間\":\"20\",\"変動ディレイ\":\"\",\"→拡大率\":\"\",\"→拡大率X\":\"\",\"→拡大率Y\":\"\",\"→拡大率Z\":\"\",\"→回転X\":\"\",\"→回転Y\":\"\",\"→回転Z\":\"\",\"向き対応\":\"\",\"向き回転X\":\"true\",\"向き回転Y\":\"true\",\"向き回転R\":\"\",\"回転時間\":\"15\",\"特殊効果\":\"\",\"画面ストップ\":\"0, 0\"}"]
 * 
 * @param アニメコモン_2
 * @parent アニメコモン登録
 * @desc アニメコモンその2。どれを使ってもよい
 * @type struct<animeCommon>[]
 * @default ["{\"コモン名\":\"■複合\",\"再生回数\":\"1\",\"開始ウェイト\":\"0\",\"中間ウェイト\":\"0\",\"レイヤー\":\"B1\",\"ズーム対応\":\"true\",\"表示範囲\":\"0\",\"位置\":\"\",\"位置ずらしX\":\"0\",\"位置ずらしY\":\"0\",\"発生\":\"\",\"発生数\":\"1\",\"発生ルート\":\"[]\",\"発生ずらしX\":\"0\",\"発生ずらしY\":\"0\",\"最初は初期位置\":\"false\",\"発生ディレイ\":\"0\",\"移動\":\"\",\"移動時間\":\"20\",\"移動ディレイ\":\"0\",\"移動X\":\"0\",\"移動Y\":\"0\",\"移動リセットX\":\"true\",\"移動リセットY\":\"true\",\"パーティクル設定\":\"\",\"拡大率\":\"\",\"拡大率X\":\"\",\"拡大率Y\":\"\",\"拡大率Z\":\"\",\"回転X\":\"\",\"回転Y\":\"\",\"回転Z\":\"\",\"速度\":\"\",\"オフセットX\":\"\",\"オフセットY\":\"\",\"下揃え\":\"false\",\"効果音-音量率\":\"\",\"効果音-ピッチ率\":\"\",\"フラッシュなし\":\"false\",\"効果音なし\":\"false\",\"パーティクル変動\":\"\",\"変動時間\":\"20\",\"変動ディレイ\":\"0\",\"→拡大率\":\"\",\"→拡大率X\":\"\",\"→拡大率Y\":\"\",\"→拡大率Z\":\"\",\"→回転X\":\"\",\"→回転Y\":\"\",\"→回転Z\":\"\",\"向き対応\":\"\",\"向き回転X\":\"false\",\"向き回転Y\":\"false\",\"向き回転R\":\"false\",\"回転時間\":\"15\",\"特殊効果\":\"\",\"画面ストップ\":\"0, 0\"}","{\"コモン名\":\"インパクト\",\"再生回数\":\"1\",\"開始ウェイト\":\"\",\"中間ウェイト\":\"\",\"レイヤー\":\"B1\",\"ズーム対応\":\"true\",\"表示範囲\":\"\",\"位置\":\"\",\"位置ずらしX\":\"\",\"位置ずらしY\":\"\",\"発生\":\"\",\"発生数\":\"1\",\"発生ルート\":\"\",\"発生ずらしX\":\"\",\"発生ずらしY\":\"\",\"最初は初期位置\":\"\",\"発生ディレイ\":\"\",\"移動\":\"\",\"移動時間\":\"20\",\"移動ディレイ\":\"\",\"移動X\":\"\",\"移動Y\":\"\",\"移動リセットX\":\"true\",\"移動リセットY\":\"true\",\"パーティクル設定\":\"\",\"拡大率\":\"\",\"拡大率X\":\"\",\"拡大率Y\":\"\",\"拡大率Z\":\"\",\"回転X\":\"\",\"回転Y\":\"\",\"回転Z\":\"\",\"速度\":\"250\",\"オフセットX\":\"\",\"オフセットY\":\"\",\"下揃え\":\"\",\"効果音-音量率\":\"\",\"効果音-ピッチ率\":\"\",\"フラッシュなし\":\"\",\"効果音なし\":\"true\",\"パーティクル変動\":\"\",\"変動時間\":\"20\",\"変動ディレイ\":\"\",\"→拡大率\":\"*2.5\",\"→拡大率X\":\"\",\"→拡大率Y\":\"\",\"→拡大率Z\":\"\",\"→回転X\":\"360\",\"→回転Y\":\"\",\"→回転Z\":\"\",\"向き対応\":\"\",\"向き回転X\":\"true\",\"向き回転Y\":\"true\",\"向き回転R\":\"\",\"回転時間\":\"15\",\"特殊効果\":\"\",\"画面ストップ\":\"0, 0\"}","{\"コモン名\":\"インパクト-遅\",\"再生回数\":\"1\",\"開始ウェイト\":\"\",\"中間ウェイト\":\"\",\"レイヤー\":\"B1\",\"ズーム対応\":\"true\",\"表示範囲\":\"\",\"位置\":\"\",\"位置ずらしX\":\"\",\"位置ずらしY\":\"\",\"発生\":\"\",\"発生数\":\"1\",\"発生ルート\":\"\",\"発生ずらしX\":\"\",\"発生ずらしY\":\"\",\"最初は初期位置\":\"\",\"発生ディレイ\":\"\",\"移動\":\"\",\"移動時間\":\"20\",\"移動ディレイ\":\"\",\"移動X\":\"\",\"移動Y\":\"\",\"移動リセットX\":\"true\",\"移動リセットY\":\"true\",\"パーティクル設定\":\"\",\"拡大率\":\"\",\"拡大率X\":\"\",\"拡大率Y\":\"\",\"拡大率Z\":\"\",\"回転X\":\"\",\"回転Y\":\"\",\"回転Z\":\"\",\"速度\":\"100\",\"オフセットX\":\"\",\"オフセットY\":\"\",\"下揃え\":\"\",\"効果音-音量率\":\"\",\"効果音-ピッチ率\":\"\",\"フラッシュなし\":\"\",\"効果音なし\":\"true\",\"パーティクル変動\":\"\",\"変動時間\":\"20\",\"変動ディレイ\":\"\",\"→拡大率\":\"*2.5\",\"→拡大率X\":\"\",\"→拡大率Y\":\"\",\"→拡大率Z\":\"\",\"→回転X\":\"\",\"→回転Y\":\"\",\"→回転Z\":\"\",\"向き対応\":\"\",\"向き回転X\":\"true\",\"向き回転Y\":\"true\",\"向き回転R\":\"\",\"回転時間\":\"15\",\"特殊効果\":\"\",\"画面ストップ\":\"0, 0\"}","{\"コモン名\":\"フラッシュ\",\"再生回数\":\"1\",\"開始ウェイト\":\"\",\"中間ウェイト\":\"\",\"レイヤー\":\"C1\",\"ズーム対応\":\"true\",\"表示範囲\":\"\",\"位置\":\"\",\"位置ずらしX\":\"\",\"位置ずらしY\":\"\",\"発生\":\"\",\"発生数\":\"1\",\"発生ルート\":\"\",\"発生ずらしX\":\"\",\"発生ずらしY\":\"\",\"最初は初期位置\":\"\",\"発生ディレイ\":\"\",\"移動\":\"\",\"移動時間\":\"20\",\"移動ディレイ\":\"\",\"移動X\":\"\",\"移動Y\":\"\",\"移動リセットX\":\"true\",\"移動リセットY\":\"true\",\"パーティクル設定\":\"\",\"拡大率\":\"\",\"拡大率X\":\"\",\"拡大率Y\":\"\",\"拡大率Z\":\"\",\"回転X\":\"\",\"回転Y\":\"\",\"回転Z\":\"\",\"速度\":\"250\",\"オフセットX\":\"\",\"オフセットY\":\"\",\"下揃え\":\"\",\"効果音-音量率\":\"\",\"効果音-ピッチ率\":\"\",\"フラッシュなし\":\"\",\"効果音なし\":\"\",\"パーティクル変動\":\"\",\"変動時間\":\"20\",\"変動ディレイ\":\"\",\"→拡大率\":\"\",\"→拡大率X\":\"\",\"→拡大率Y\":\"\",\"→拡大率Z\":\"\",\"→回転X\":\"\",\"→回転Y\":\"\",\"→回転Z\":\"\",\"向き対応\":\"\",\"向き回転X\":\"true\",\"向き回転Y\":\"true\",\"向き回転R\":\"\",\"回転時間\":\"15\",\"特殊効果\":\"\",\"画面ストップ\":\"0, 0\"}","{\"コモン名\":\"オーラ\",\"再生回数\":\"1\",\"開始ウェイト\":\"\",\"中間ウェイト\":\"\",\"レイヤー\":\"A1\",\"ズーム対応\":\"true\",\"表示範囲\":\"\",\"位置\":\"\",\"位置ずらしX\":\"\",\"位置ずらしY\":\"\",\"発生\":\"\",\"発生数\":\"1\",\"発生ルート\":\"\",\"発生ずらしX\":\"\",\"発生ずらしY\":\"\",\"最初は初期位置\":\"\",\"発生ディレイ\":\"\",\"移動\":\"\",\"移動時間\":\"20\",\"移動ディレイ\":\"\",\"移動X\":\"\",\"移動Y\":\"\",\"移動リセットX\":\"true\",\"移動リセットY\":\"true\",\"パーティクル設定\":\"\",\"拡大率\":\"\",\"拡大率X\":\"\",\"拡大率Y\":\"\",\"拡大率Z\":\"\",\"回転X\":\"\",\"回転Y\":\"\",\"回転Z\":\"\",\"速度\":\"100\",\"オフセットX\":\"\",\"オフセットY\":\"\",\"下揃え\":\"\",\"効果音-音量率\":\"\",\"効果音-ピッチ率\":\"\",\"フラッシュなし\":\"\",\"効果音なし\":\"true\",\"パーティクル変動\":\"\",\"変動時間\":\"20\",\"変動ディレイ\":\"\",\"→拡大率\":\"*2.5\",\"→拡大率X\":\"\",\"→拡大率Y\":\"\",\"→拡大率Z\":\"\",\"→回転X\":\"\",\"→回転Y\":\"\",\"→回転Z\":\"\",\"向き対応\":\"\",\"向き回転X\":\"true\",\"向き回転Y\":\"true\",\"向き回転R\":\"\",\"回転時間\":\"15\",\"特殊効果\":\"\",\"画面ストップ\":\"0, 0\"}","{\"コモン名\":\"バリア\",\"再生回数\":\"1\",\"開始ウェイト\":\"\",\"中間ウェイト\":\"\",\"レイヤー\":\"B1\",\"ズーム対応\":\"true\",\"表示範囲\":\"\",\"位置\":\"\",\"位置ずらしX\":\"\",\"位置ずらしY\":\"\",\"発生\":\"\",\"発生数\":\"1\",\"発生ルート\":\"\",\"発生ずらしX\":\"\",\"発生ずらしY\":\"\",\"最初は初期位置\":\"\",\"発生ディレイ\":\"\",\"移動\":\"\",\"移動時間\":\"20\",\"移動ディレイ\":\"\",\"移動X\":\"\",\"移動Y\":\"\",\"移動リセットX\":\"true\",\"移動リセットY\":\"true\",\"パーティクル設定\":\"\",\"拡大率\":\"\",\"拡大率X\":\"\",\"拡大率Y\":\"\",\"拡大率Z\":\"\",\"回転X\":\"\",\"回転Y\":\"\",\"回転Z\":\"\",\"速度\":\"100\",\"オフセットX\":\"\",\"オフセットY\":\"\",\"下揃え\":\"\",\"効果音-音量率\":\"\",\"効果音-ピッチ率\":\"\",\"フラッシュなし\":\"\",\"効果音なし\":\"\",\"パーティクル変動\":\"\",\"変動時間\":\"60\",\"変動ディレイ\":\"\",\"→拡大率\":\"40\",\"→拡大率X\":\"\",\"→拡大率Y\":\"\",\"→拡大率Z\":\"\",\"→回転X\":\"1800\",\"→回転Y\":\"\",\"→回転Z\":\"\",\"向き対応\":\"\",\"向き回転X\":\"true\",\"向き回転Y\":\"true\",\"向き回転R\":\"\",\"回転時間\":\"15\",\"特殊効果\":\"\",\"画面ストップ\":\"0, 0\"}","{\"コモン名\":\"バリア-大\",\"再生回数\":\"1\",\"開始ウェイト\":\"\",\"中間ウェイト\":\"\",\"レイヤー\":\"B1\",\"ズーム対応\":\"true\",\"表示範囲\":\"\",\"位置\":\"\",\"位置ずらしX\":\"\",\"位置ずらしY\":\"\",\"発生\":\"\",\"発生数\":\"1\",\"発生ルート\":\"\",\"発生ずらしX\":\"\",\"発生ずらしY\":\"\",\"最初は初期位置\":\"\",\"発生ディレイ\":\"\",\"移動\":\"\",\"移動時間\":\"20\",\"移動ディレイ\":\"\",\"移動X\":\"\",\"移動Y\":\"\",\"移動リセットX\":\"true\",\"移動リセットY\":\"true\",\"パーティクル設定\":\"\",\"拡大率\":\"\",\"拡大率X\":\"\",\"拡大率Y\":\"\",\"拡大率Z\":\"\",\"回転X\":\"\",\"回転Y\":\"\",\"回転Z\":\"\",\"速度\":\"100\",\"オフセットX\":\"\",\"オフセットY\":\"\",\"下揃え\":\"\",\"効果音-音量率\":\"\",\"効果音-ピッチ率\":\"\",\"フラッシュなし\":\"\",\"効果音なし\":\"\",\"パーティクル変動\":\"\",\"変動時間\":\"60\",\"変動ディレイ\":\"\",\"→拡大率\":\"80\",\"→拡大率X\":\"\",\"→拡大率Y\":\"\",\"→拡大率Z\":\"\",\"→回転X\":\"1800\",\"→回転Y\":\"\",\"→回転Z\":\"\",\"向き対応\":\"\",\"向き回転X\":\"true\",\"向き回転Y\":\"true\",\"向き回転R\":\"\",\"回転時間\":\"15\",\"特殊効果\":\"\",\"画面ストップ\":\"0, 0\"}","{\"コモン名\":\"クラッシュ\",\"再生回数\":\"1\",\"開始ウェイト\":\"\",\"中間ウェイト\":\"\",\"レイヤー\":\"B1\",\"ズーム対応\":\"true\",\"表示範囲\":\"\",\"位置\":\"\",\"位置ずらしX\":\"\",\"位置ずらしY\":\"\",\"発生\":\"\",\"発生数\":\"1\",\"発生ルート\":\"\",\"発生ずらしX\":\"\",\"発生ずらしY\":\"\",\"最初は初期位置\":\"\",\"発生ディレイ\":\"\",\"移動\":\"\",\"移動時間\":\"20\",\"移動ディレイ\":\"\",\"移動X\":\"\",\"移動Y\":\"\",\"移動リセットX\":\"true\",\"移動リセットY\":\"true\",\"パーティクル設定\":\"\",\"拡大率\":\"\",\"拡大率X\":\"\",\"拡大率Y\":\"\",\"拡大率Z\":\"\",\"回転X\":\"\",\"回転Y\":\"\",\"回転Z\":\"\",\"速度\":\"300\",\"オフセットX\":\"\",\"オフセットY\":\"\",\"下揃え\":\"\",\"効果音-音量率\":\"\",\"効果音-ピッチ率\":\"\",\"フラッシュなし\":\"\",\"効果音なし\":\"true\",\"パーティクル変動\":\"\",\"変動時間\":\"10\",\"変動ディレイ\":\"\",\"→拡大率\":\"*1.5\",\"→拡大率X\":\"\",\"→拡大率Y\":\"\",\"→拡大率Z\":\"\",\"→回転X\":\"\",\"→回転Y\":\"\",\"→回転Z\":\"\",\"向き対応\":\"\",\"向き回転X\":\"true\",\"向き回転Y\":\"true\",\"向き回転R\":\"\",\"回転時間\":\"15\",\"特殊効果\":\"\",\"画面ストップ\":\"0, 0\"}","{\"コモン名\":\"ボスクラッシュ\",\"再生回数\":\"1\",\"開始ウェイト\":\"\",\"中間ウェイト\":\"\",\"レイヤー\":\"B1\",\"ズーム対応\":\"true\",\"表示範囲\":\"\",\"位置\":\"\",\"位置ずらしX\":\"\",\"位置ずらしY\":\"\",\"発生\":\"\",\"発生数\":\"1\",\"発生ルート\":\"\",\"発生ずらしX\":\"\",\"発生ずらしY\":\"\",\"最初は初期位置\":\"\",\"発生ディレイ\":\"\",\"移動\":\"\",\"移動時間\":\"20\",\"移動ディレイ\":\"\",\"移動X\":\"\",\"移動Y\":\"\",\"移動リセットX\":\"true\",\"移動リセットY\":\"true\",\"パーティクル設定\":\"\",\"拡大率\":\"\",\"拡大率X\":\"\",\"拡大率Y\":\"\",\"拡大率Z\":\"\",\"回転X\":\"\",\"回転Y\":\"\",\"回転Z\":\"\",\"速度\":\"25\",\"オフセットX\":\"\",\"オフセットY\":\"\",\"下揃え\":\"\",\"効果音-音量率\":\"\",\"効果音-ピッチ率\":\"\",\"フラッシュなし\":\"\",\"効果音なし\":\"true\",\"パーティクル変動\":\"\",\"変動時間\":\"20\",\"変動ディレイ\":\"\",\"→拡大率\":\"*2\",\"→拡大率X\":\"\",\"→拡大率Y\":\"\",\"→拡大率Z\":\"\",\"→回転X\":\"720\",\"→回転Y\":\"720\",\"→回転Z\":\"720\",\"向き対応\":\"\",\"向き回転X\":\"true\",\"向き回転Y\":\"true\",\"向き回転R\":\"\",\"回転時間\":\"15\",\"特殊効果\":\"\",\"画面ストップ\":\"0, 0\"}","{\"コモン名\":\"フラワー\",\"再生回数\":\"1\",\"開始ウェイト\":\"\",\"中間ウェイト\":\"30\",\"レイヤー\":\"B1\",\"ズーム対応\":\"true\",\"表示範囲\":\"\",\"位置\":\"\",\"位置ずらしX\":\"\",\"位置ずらしY\":\"\",\"発生\":\"\",\"発生数\":\"10\",\"発生ルート\":\"\",\"発生ずらしX\":\"\",\"発生ずらしY\":\"\",\"最初は初期位置\":\"\",\"発生ディレイ\":\"10\",\"移動\":\"\",\"移動時間\":\"20\",\"移動ディレイ\":\"\",\"移動X\":\"\",\"移動Y\":\"\",\"移動リセットX\":\"true\",\"移動リセットY\":\"true\",\"パーティクル設定\":\"\",\"拡大率\":\"60 ~ 120\",\"拡大率X\":\"\",\"拡大率Y\":\"\",\"拡大率Z\":\"\",\"回転X\":\"\",\"回転Y\":\"\",\"回転Z\":\"\",\"速度\":\"250\",\"オフセットX\":\"-200 ~ 200\",\"オフセットY\":\"-200 ~ 200\",\"下揃え\":\"\",\"効果音-音量率\":\"\",\"効果音-ピッチ率\":\"\",\"フラッシュなし\":\"\",\"効果音なし\":\"\",\"パーティクル変動\":\"\",\"変動時間\":\"20\",\"変動ディレイ\":\"\",\"→拡大率\":\"\",\"→拡大率X\":\"\",\"→拡大率Y\":\"\",\"→拡大率Z\":\"\",\"→回転X\":\"\",\"→回転Y\":\"\",\"→回転Z\":\"\",\"向き対応\":\"\",\"向き回転X\":\"true\",\"向き回転Y\":\"true\",\"向き回転R\":\"\",\"回転時間\":\"15\",\"特殊効果\":\"\",\"画面ストップ\":\"0, 0\"}","{\"コモン名\":\"ミニフラワー\",\"再生回数\":\"1\",\"開始ウェイト\":\"\",\"中間ウェイト\":\"30\",\"レイヤー\":\"B1\",\"ズーム対応\":\"true\",\"表示範囲\":\"\",\"位置\":\"\",\"位置ずらしX\":\"\",\"位置ずらしY\":\"\",\"発生\":\"\",\"発生数\":\"7\",\"発生ルート\":\"\",\"発生ずらしX\":\"\",\"発生ずらしY\":\"\",\"最初は初期位置\":\"\",\"発生ディレイ\":\"10\",\"移動\":\"\",\"移動時間\":\"20\",\"移動ディレイ\":\"\",\"移動X\":\"\",\"移動Y\":\"\",\"移動リセットX\":\"true\",\"移動リセットY\":\"true\",\"パーティクル設定\":\"\",\"拡大率\":\"45~90\",\"拡大率X\":\"\",\"拡大率Y\":\"\",\"拡大率Z\":\"\",\"回転X\":\"\",\"回転Y\":\"\",\"回転Z\":\"\",\"速度\":\"250\",\"オフセットX\":\"-75~75\",\"オフセットY\":\"-75~75\",\"下揃え\":\"\",\"効果音-音量率\":\"\",\"効果音-ピッチ率\":\"\",\"フラッシュなし\":\"\",\"効果音なし\":\"\",\"パーティクル変動\":\"\",\"変動時間\":\"20\",\"変動ディレイ\":\"\",\"→拡大率\":\"\",\"→拡大率X\":\"\",\"→拡大率Y\":\"\",\"→拡大率Z\":\"\",\"→回転X\":\"1800\",\"→回転Y\":\"\",\"→回転Z\":\"\",\"向き対応\":\"\",\"向き回転X\":\"true\",\"向き回転Y\":\"true\",\"向き回転R\":\"\",\"回転時間\":\"15\",\"特殊効果\":\"\",\"画面ストップ\":\"0, 0\"}","{\"コモン名\":\"バースト\",\"再生回数\":\"1\",\"開始ウェイト\":\"\",\"中間ウェイト\":\"\",\"レイヤー\":\"B1\",\"ズーム対応\":\"true\",\"表示範囲\":\"\",\"位置\":\"\",\"位置ずらしX\":\"\",\"位置ずらしY\":\"\",\"発生\":\"\",\"発生数\":\"1\",\"発生ルート\":\"\",\"発生ずらしX\":\"\",\"発生ずらしY\":\"\",\"最初は初期位置\":\"\",\"発生ディレイ\":\"\",\"移動\":\"\",\"移動時間\":\"20\",\"移動ディレイ\":\"\",\"移動X\":\"\",\"移動Y\":\"\",\"移動リセットX\":\"true\",\"移動リセットY\":\"true\",\"パーティクル設定\":\"\",\"拡大率\":\"0\",\"拡大率X\":\"\",\"拡大率Y\":\"\",\"拡大率Z\":\"\",\"回転X\":\"\",\"回転Y\":\"\",\"回転Z\":\"\",\"速度\":\"\",\"オフセットX\":\"\",\"オフセットY\":\"\",\"下揃え\":\"\",\"効果音-音量率\":\"\",\"効果音-ピッチ率\":\"\",\"フラッシュなし\":\"\",\"効果音なし\":\"\",\"パーティクル変動\":\"\",\"変動時間\":\"30\",\"変動ディレイ\":\"\",\"→拡大率\":\"200\",\"→拡大率X\":\"\",\"→拡大率Y\":\"\",\"→拡大率Z\":\"\",\"→回転X\":\"1800\",\"→回転Y\":\"1800\",\"→回転Z\":\"1800\",\"向き対応\":\"\",\"向き回転X\":\"true\",\"向き回転Y\":\"true\",\"向き回転R\":\"\",\"回転時間\":\"15\",\"特殊効果\":\"\",\"画面ストップ\":\"0, 0\"}","{\"コモン名\":\"バースト-小\",\"再生回数\":\"1\",\"開始ウェイト\":\"\",\"中間ウェイト\":\"\",\"レイヤー\":\"B1\",\"ズーム対応\":\"true\",\"表示範囲\":\"\",\"位置\":\"\",\"位置ずらしX\":\"\",\"位置ずらしY\":\"\",\"発生\":\"\",\"発生数\":\"1\",\"発生ルート\":\"\",\"発生ずらしX\":\"\",\"発生ずらしY\":\"\",\"最初は初期位置\":\"\",\"発生ディレイ\":\"\",\"移動\":\"\",\"移動時間\":\"20\",\"移動ディレイ\":\"\",\"移動X\":\"\",\"移動Y\":\"\",\"移動リセットX\":\"true\",\"移動リセットY\":\"true\",\"パーティクル設定\":\"\",\"拡大率\":\"0\",\"拡大率X\":\"\",\"拡大率Y\":\"\",\"拡大率Z\":\"\",\"回転X\":\"\",\"回転Y\":\"\",\"回転Z\":\"\",\"速度\":\"\",\"オフセットX\":\"\",\"オフセットY\":\"\",\"下揃え\":\"\",\"効果音-音量率\":\"\",\"効果音-ピッチ率\":\"\",\"フラッシュなし\":\"\",\"効果音なし\":\"\",\"パーティクル変動\":\"\",\"変動時間\":\"30\",\"変動ディレイ\":\"\",\"→拡大率\":\"150\",\"→拡大率X\":\"\",\"→拡大率Y\":\"\",\"→拡大率Z\":\"\",\"→回転X\":\"1800\",\"→回転Y\":\"1800\",\"→回転Z\":\"1800\",\"向き対応\":\"\",\"向き回転X\":\"true\",\"向き回転Y\":\"true\",\"向き回転R\":\"\",\"回転時間\":\"15\",\"特殊効果\":\"\",\"画面ストップ\":\"0, 0\"}"]
 * 
 * @param アニメコモン_3
 * @parent アニメコモン登録
 * @desc アニメコモンその3。どれを使ってもよい
 * @type struct<animeCommon>[]
 * @default ["{\"コモン名\":\"■連射\",\"再生回数\":\"1\",\"開始ウェイト\":\"0\",\"中間ウェイト\":\"0\",\"レイヤー\":\"B1\",\"ズーム対応\":\"true\",\"表示範囲\":\"0\",\"位置\":\"\",\"位置ずらしX\":\"0\",\"位置ずらしY\":\"0\",\"発生\":\"\",\"発生数\":\"1\",\"発生ルート\":\"[]\",\"発生ずらしX\":\"0\",\"発生ずらしY\":\"0\",\"最初は初期位置\":\"false\",\"発生ディレイ\":\"0\",\"移動\":\"\",\"移動時間\":\"20\",\"移動ディレイ\":\"0\",\"移動X\":\"0\",\"移動Y\":\"0\",\"移動リセットX\":\"true\",\"移動リセットY\":\"true\",\"パーティクル設定\":\"\",\"拡大率\":\"\",\"拡大率X\":\"\",\"拡大率Y\":\"\",\"拡大率Z\":\"\",\"回転X\":\"\",\"回転Y\":\"\",\"回転Z\":\"\",\"速度\":\"\",\"オフセットX\":\"\",\"オフセットY\":\"\",\"下揃え\":\"false\",\"効果音-音量率\":\"\",\"効果音-ピッチ率\":\"\",\"フラッシュなし\":\"false\",\"効果音なし\":\"false\",\"パーティクル変動\":\"\",\"変動時間\":\"20\",\"変動ディレイ\":\"0\",\"→拡大率\":\"\",\"→拡大率X\":\"\",\"→拡大率Y\":\"\",\"→拡大率Z\":\"\",\"→回転X\":\"\",\"→回転Y\":\"\",\"→回転Z\":\"\",\"向き対応\":\"\",\"向き回転X\":\"false\",\"向き回転Y\":\"false\",\"向き回転R\":\"false\",\"回転時間\":\"15\",\"特殊効果\":\"\",\"画面ストップ\":\"0, 0\"}","{\"コモン名\":\"スプレッド\",\"再生回数\":\"1\",\"開始ウェイト\":\"\",\"中間ウェイト\":\"\",\"レイヤー\":\"B1\",\"ズーム対応\":\"true\",\"表示範囲\":\"\",\"位置\":\"\",\"位置ずらしX\":\"\",\"位置ずらしY\":\"\",\"発生\":\"\",\"発生数\":\"4\",\"発生ルート\":\"\",\"発生ずらしX\":\"\",\"発生ずらしY\":\"\",\"最初は初期位置\":\"\",\"発生ディレイ\":\"5\",\"移動\":\"\",\"移動時間\":\"30\",\"移動ディレイ\":\"\",\"移動X\":\"-50\",\"移動Y\":\"-5~5\",\"移動リセットX\":\"true\",\"移動リセットY\":\"true\",\"パーティクル設定\":\"\",\"拡大率\":\"30\",\"拡大率X\":\"\",\"拡大率Y\":\"\",\"拡大率Z\":\"\",\"回転X\":\"\",\"回転Y\":\"\",\"回転Z\":\"\",\"速度\":\"300\",\"オフセットX\":\"\",\"オフセットY\":\"\",\"下揃え\":\"\",\"効果音-音量率\":\"50\",\"効果音-ピッチ率\":\"\",\"フラッシュなし\":\"\",\"効果音なし\":\"\",\"パーティクル変動\":\"\",\"変動時間\":\"30\",\"変動ディレイ\":\"\",\"→拡大率\":\"50tn\",\"→拡大率X\":\"\",\"→拡大率Y\":\"\",\"→拡大率Z\":\"\",\"→回転X\":\"360\",\"→回転Y\":\"\",\"→回転Z\":\"\",\"向き対応\":\"\",\"向き回転X\":\"true\",\"向き回転Y\":\"true\",\"向き回転R\":\"\",\"回転時間\":\"15\",\"特殊効果\":\"\",\"画面ストップ\":\"0, 0\"}","{\"コモン名\":\"スプレッド-遅\",\"再生回数\":\"1\",\"開始ウェイト\":\"\",\"中間ウェイト\":\"\",\"レイヤー\":\"B1\",\"ズーム対応\":\"true\",\"表示範囲\":\"\",\"位置\":\"\",\"位置ずらしX\":\"\",\"位置ずらしY\":\"\",\"発生\":\"\",\"発生数\":\"4\",\"発生ルート\":\"\",\"発生ずらしX\":\"\",\"発生ずらしY\":\"\",\"最初は初期位置\":\"\",\"発生ディレイ\":\"5\",\"移動\":\"\",\"移動時間\":\"60\",\"移動ディレイ\":\"\",\"移動X\":\"-50\",\"移動Y\":\"-5~5\",\"移動リセットX\":\"true\",\"移動リセットY\":\"true\",\"パーティクル設定\":\"\",\"拡大率\":\"20\",\"拡大率X\":\"\",\"拡大率Y\":\"\",\"拡大率Z\":\"\",\"回転X\":\"\",\"回転Y\":\"\",\"回転Z\":\"\",\"速度\":\"100\",\"オフセットX\":\"\",\"オフセットY\":\"\",\"下揃え\":\"\",\"効果音-音量率\":\"50\",\"効果音-ピッチ率\":\"\",\"フラッシュなし\":\"\",\"効果音なし\":\"\",\"パーティクル変動\":\"\",\"変動時間\":\"30\",\"変動ディレイ\":\"\",\"→拡大率\":\"30tn\",\"→拡大率X\":\"\",\"→拡大率Y\":\"\",\"→拡大率Z\":\"\",\"→回転X\":\"360\",\"→回転Y\":\"\",\"→回転Z\":\"\",\"向き対応\":\"\",\"向き回転X\":\"true\",\"向き回転Y\":\"true\",\"向き回転R\":\"\",\"回転時間\":\"15\",\"特殊効果\":\"\",\"画面ストップ\":\"0, 0\"}","{\"コモン名\":\"スプレッド-大\",\"再生回数\":\"1\",\"開始ウェイト\":\"\",\"中間ウェイト\":\"\",\"レイヤー\":\"B1\",\"ズーム対応\":\"true\",\"表示範囲\":\"\",\"位置\":\"\",\"位置ずらしX\":\"\",\"位置ずらしY\":\"\",\"発生\":\"\",\"発生数\":\"3\",\"発生ルート\":\"\",\"発生ずらしX\":\"\",\"発生ずらしY\":\"\",\"最初は初期位置\":\"\",\"発生ディレイ\":\"5\",\"移動\":\"\",\"移動時間\":\"30\",\"移動ディレイ\":\"\",\"移動X\":\"-50\",\"移動Y\":\"-5~5\",\"移動リセットX\":\"true\",\"移動リセットY\":\"true\",\"パーティクル設定\":\"\",\"拡大率\":\"50\",\"拡大率X\":\"\",\"拡大率Y\":\"\",\"拡大率Z\":\"\",\"回転X\":\"\",\"回転Y\":\"\",\"回転Z\":\"\",\"速度\":\"300\",\"オフセットX\":\"\",\"オフセットY\":\"\",\"下揃え\":\"\",\"効果音-音量率\":\"50\",\"効果音-ピッチ率\":\"\",\"フラッシュなし\":\"\",\"効果音なし\":\"\",\"パーティクル変動\":\"\",\"変動時間\":\"30\",\"変動ディレイ\":\"\",\"→拡大率\":\"75tn\",\"→拡大率X\":\"\",\"→拡大率Y\":\"\",\"→拡大率Z\":\"\",\"→回転X\":\"360\",\"→回転Y\":\"\",\"→回転Z\":\"\",\"向き対応\":\"\",\"向き回転X\":\"true\",\"向き回転Y\":\"true\",\"向き回転R\":\"\",\"回転時間\":\"15\",\"特殊効果\":\"\",\"画面ストップ\":\"0, 0\"}","{\"コモン名\":\"スプレッド-大-遅\",\"再生回数\":\"1\",\"開始ウェイト\":\"\",\"中間ウェイト\":\"\",\"レイヤー\":\"B1\",\"ズーム対応\":\"true\",\"表示範囲\":\"\",\"位置\":\"\",\"位置ずらしX\":\"\",\"位置ずらしY\":\"\",\"発生\":\"\",\"発生数\":\"3\",\"発生ルート\":\"\",\"発生ずらしX\":\"\",\"発生ずらしY\":\"\",\"最初は初期位置\":\"\",\"発生ディレイ\":\"5\",\"移動\":\"\",\"移動時間\":\"30\",\"移動ディレイ\":\"\",\"移動X\":\"-50\",\"移動Y\":\"-5~5\",\"移動リセットX\":\"true\",\"移動リセットY\":\"true\",\"パーティクル設定\":\"\",\"拡大率\":\"50\",\"拡大率X\":\"\",\"拡大率Y\":\"\",\"拡大率Z\":\"\",\"回転X\":\"\",\"回転Y\":\"\",\"回転Z\":\"\",\"速度\":\"100\",\"オフセットX\":\"\",\"オフセットY\":\"\",\"下揃え\":\"\",\"効果音-音量率\":\"50\",\"効果音-ピッチ率\":\"\",\"フラッシュなし\":\"\",\"効果音なし\":\"\",\"パーティクル変動\":\"\",\"変動時間\":\"30\",\"変動ディレイ\":\"\",\"→拡大率\":\"75tn\",\"→拡大率X\":\"\",\"→拡大率Y\":\"\",\"→拡大率Z\":\"\",\"→回転X\":\"360\",\"→回転Y\":\"\",\"→回転Z\":\"\",\"向き対応\":\"\",\"向き回転X\":\"true\",\"向き回転Y\":\"true\",\"向き回転R\":\"\",\"回転時間\":\"15\",\"特殊効果\":\"\",\"画面ストップ\":\"0, 0\"}","{\"コモン名\":\"スプレッド-大-遅2\",\"再生回数\":\"1\",\"開始ウェイト\":\"\",\"中間ウェイト\":\"\",\"レイヤー\":\"B1\",\"ズーム対応\":\"true\",\"表示範囲\":\"\",\"位置\":\"\",\"位置ずらしX\":\"\",\"位置ずらしY\":\"\",\"発生\":\"\",\"発生数\":\"3\",\"発生ルート\":\"\",\"発生ずらしX\":\"\",\"発生ずらしY\":\"\",\"最初は初期位置\":\"\",\"発生ディレイ\":\"5\",\"移動\":\"\",\"移動時間\":\"30\",\"移動ディレイ\":\"\",\"移動X\":\"-50\",\"移動Y\":\"-5~5\",\"移動リセットX\":\"true\",\"移動リセットY\":\"true\",\"パーティクル設定\":\"\",\"拡大率\":\"50\",\"拡大率X\":\"\",\"拡大率Y\":\"\",\"拡大率Z\":\"\",\"回転X\":\"\",\"回転Y\":\"\",\"回転Z\":\"\",\"速度\":\"50\",\"オフセットX\":\"\",\"オフセットY\":\"\",\"下揃え\":\"\",\"効果音-音量率\":\"50\",\"効果音-ピッチ率\":\"\",\"フラッシュなし\":\"\",\"効果音なし\":\"\",\"パーティクル変動\":\"\",\"変動時間\":\"30\",\"変動ディレイ\":\"\",\"→拡大率\":\"75tn\",\"→拡大率X\":\"\",\"→拡大率Y\":\"\",\"→拡大率Z\":\"\",\"→回転X\":\"360\",\"→回転Y\":\"\",\"→回転Z\":\"\",\"向き対応\":\"\",\"向き回転X\":\"true\",\"向き回転Y\":\"true\",\"向き回転R\":\"\",\"回転時間\":\"15\",\"特殊効果\":\"\",\"画面ストップ\":\"0, 0\"}","{\"コモン名\":\"ラピッド\",\"再生回数\":\"1\",\"開始ウェイト\":\"\",\"中間ウェイト\":\"\",\"レイヤー\":\"B1\",\"ズーム対応\":\"true\",\"表示範囲\":\"\",\"位置\":\"\",\"位置ずらしX\":\"\",\"位置ずらしY\":\"\",\"発生\":\"\",\"発生数\":\"3\",\"発生ルート\":\"\",\"発生ずらしX\":\"\",\"発生ずらしY\":\"\",\"最初は初期位置\":\"false\",\"発生ディレイ\":\"10\",\"移動\":\"\",\"移動時間\":\"20\",\"移動ディレイ\":\"\",\"移動X\":\"-100~100\",\"移動Y\":\"-10~10\",\"移動リセットX\":\"true\",\"移動リセットY\":\"true\",\"パーティクル設定\":\"\",\"拡大率\":\"30\",\"拡大率X\":\"\",\"拡大率Y\":\"\",\"拡大率Z\":\"\",\"回転X\":\"\",\"回転Y\":\"\",\"回転Z\":\"\",\"速度\":\"300\",\"オフセットX\":\"\",\"オフセットY\":\"\",\"下揃え\":\"\",\"効果音-音量率\":\"50\",\"効果音-ピッチ率\":\"\",\"フラッシュなし\":\"\",\"効果音なし\":\"\",\"パーティクル変動\":\"\",\"変動時間\":\"20\",\"変動ディレイ\":\"\",\"→拡大率\":\"\",\"→拡大率X\":\"\",\"→拡大率Y\":\"\",\"→拡大率Z\":\"\",\"→回転X\":\"360\",\"→回転Y\":\"\",\"→回転Z\":\"\",\"向き対応\":\"\",\"向き回転X\":\"true\",\"向き回転Y\":\"true\",\"向き回転R\":\"\",\"回転時間\":\"15\",\"特殊効果\":\"\",\"画面ストップ\":\"0, 0\"}","{\"コモン名\":\"手裏剣\",\"再生回数\":\"1\",\"開始ウェイト\":\"\",\"中間ウェイト\":\"\",\"レイヤー\":\"B1\",\"ズーム対応\":\"true\",\"表示範囲\":\"\",\"位置\":\"\",\"位置ずらしX\":\"-30\",\"位置ずらしY\":\"-24\",\"発生\":\"\",\"発生数\":\"4\",\"発生ルート\":\"\",\"発生ずらしX\":\"\",\"発生ずらしY\":\"\",\"最初は初期位置\":\"false\",\"発生ディレイ\":\"10\",\"移動\":\"\",\"移動時間\":\"50\",\"移動ディレイ\":\"\",\"移動X\":\"-100~100\",\"移動Y\":\"-10~10\",\"移動リセットX\":\"true\",\"移動リセットY\":\"true\",\"パーティクル設定\":\"\",\"拡大率\":\"45\",\"拡大率X\":\"\",\"拡大率Y\":\"\",\"拡大率Z\":\"\",\"回転X\":\"\",\"回転Y\":\"\",\"回転Z\":\"\",\"速度\":\"300\",\"オフセットX\":\"\",\"オフセットY\":\"\",\"下揃え\":\"false\",\"効果音-音量率\":\"50\",\"効果音-ピッチ率\":\"\",\"フラッシュなし\":\"\",\"効果音なし\":\"\",\"パーティクル変動\":\"\",\"変動時間\":\"50\",\"変動ディレイ\":\"\",\"→拡大率\":\"\",\"→拡大率X\":\"\",\"→拡大率Y\":\"\",\"→拡大率Z\":\"\",\"→回転X\":\"360\",\"→回転Y\":\"\",\"→回転Z\":\"\",\"向き対応\":\"\",\"向き回転X\":\"true\",\"向き回転Y\":\"true\",\"向き回転R\":\"\",\"回転時間\":\"15\",\"特殊効果\":\"\",\"画面ストップ\":\"0, 0\"}"]
 * 
 * @param アニメコモン_4
 * @parent アニメコモン登録
 * @desc アニメコモンその4。どれを使ってもよい
 * @type struct<animeCommon>[]
 * @default ["{\"コモン名\":\"■ループ\",\"再生回数\":\"1\",\"開始ウェイト\":\"0\",\"中間ウェイト\":\"0\",\"レイヤー\":\"B1\",\"ズーム対応\":\"true\",\"表示範囲\":\"0\",\"位置\":\"\",\"位置ずらしX\":\"0\",\"位置ずらしY\":\"0\",\"発生\":\"\",\"発生数\":\"1\",\"発生ルート\":\"[]\",\"発生ずらしX\":\"0\",\"発生ずらしY\":\"0\",\"最初は初期位置\":\"false\",\"発生ディレイ\":\"0\",\"移動\":\"\",\"移動時間\":\"20\",\"移動ディレイ\":\"0\",\"移動X\":\"0\",\"移動Y\":\"0\",\"移動リセットX\":\"true\",\"移動リセットY\":\"true\",\"パーティクル設定\":\"\",\"拡大率\":\"\",\"拡大率X\":\"\",\"拡大率Y\":\"\",\"拡大率Z\":\"\",\"回転X\":\"\",\"回転Y\":\"\",\"回転Z\":\"\",\"速度\":\"\",\"オフセットX\":\"\",\"オフセットY\":\"\",\"下揃え\":\"false\",\"効果音-音量率\":\"\",\"効果音-ピッチ率\":\"\",\"フラッシュなし\":\"false\",\"効果音なし\":\"false\",\"パーティクル変動\":\"\",\"変動時間\":\"20\",\"変動ディレイ\":\"0\",\"→拡大率\":\"\",\"→拡大率X\":\"\",\"→拡大率Y\":\"\",\"→拡大率Z\":\"\",\"→回転X\":\"\",\"→回転Y\":\"\",\"→回転Z\":\"\",\"向き対応\":\"\",\"向き回転X\":\"false\",\"向き回転Y\":\"false\",\"向き回転R\":\"false\",\"回転時間\":\"15\",\"特殊効果\":\"\",\"画面ストップ\":\"0, 0\"}","{\"コモン名\":\"ループ\",\"再生回数\":\"-1\",\"開始ウェイト\":\"\",\"中間ウェイト\":\"\",\"レイヤー\":\"B1\",\"ズーム対応\":\"true\",\"表示範囲\":\"150\",\"位置\":\"\",\"位置ずらしX\":\"\",\"位置ずらしY\":\"\",\"発生\":\"\",\"発生数\":\"1\",\"発生ルート\":\"\",\"発生ずらしX\":\"\",\"発生ずらしY\":\"\",\"最初は初期位置\":\"\",\"発生ディレイ\":\"\",\"移動\":\"\",\"移動時間\":\"20\",\"移動ディレイ\":\"\",\"移動X\":\"\",\"移動Y\":\"\",\"移動リセットX\":\"true\",\"移動リセットY\":\"true\",\"パーティクル設定\":\"\",\"拡大率\":\"\",\"拡大率X\":\"\",\"拡大率Y\":\"\",\"拡大率Z\":\"\",\"回転X\":\"\",\"回転Y\":\"\",\"回転Z\":\"\",\"速度\":\"\",\"オフセットX\":\"\",\"オフセットY\":\"\",\"下揃え\":\"\",\"効果音-音量率\":\"\",\"効果音-ピッチ率\":\"\",\"フラッシュなし\":\"\",\"効果音なし\":\"\",\"パーティクル変動\":\"\",\"変動時間\":\"20\",\"変動ディレイ\":\"\",\"→拡大率\":\"\",\"→拡大率X\":\"\",\"→拡大率Y\":\"\",\"→拡大率Z\":\"\",\"→回転X\":\"\",\"→回転Y\":\"\",\"→回転Z\":\"\",\"向き対応\":\"\",\"向き回転X\":\"true\",\"向き回転Y\":\"true\",\"向き回転R\":\"\",\"回転時間\":\"15\",\"特殊効果\":\"\",\"画面ストップ\":\"0, 0\"}","{\"コモン名\":\"ループ-2k\",\"再生回数\":\"-1\",\"開始ウェイト\":\"\",\"中間ウェイト\":\"\",\"レイヤー\":\"B1\",\"ズーム対応\":\"true\",\"表示範囲\":\"150\",\"位置\":\"\",\"位置ずらしX\":\"\",\"位置ずらしY\":\"\",\"発生\":\"\",\"発生数\":\"2\",\"発生ルート\":\"\",\"発生ずらしX\":\"\",\"発生ずらしY\":\"\",\"最初は初期位置\":\"\",\"発生ディレイ\":\"200\",\"移動\":\"\",\"移動時間\":\"20\",\"移動ディレイ\":\"\",\"移動X\":\"\",\"移動Y\":\"\",\"移動リセットX\":\"true\",\"移動リセットY\":\"true\",\"パーティクル設定\":\"\",\"拡大率\":\"50\",\"拡大率X\":\"\",\"拡大率Y\":\"\",\"拡大率Z\":\"\",\"回転X\":\"\",\"回転Y\":\"\",\"回転Z\":\"\",\"速度\":\"20\",\"オフセットX\":\"\",\"オフセットY\":\"\",\"下揃え\":\"\",\"効果音-音量率\":\"\",\"効果音-ピッチ率\":\"\",\"フラッシュなし\":\"true\",\"効果音なし\":\"true\",\"パーティクル変動\":\"\",\"変動時間\":\"20\",\"変動ディレイ\":\"\",\"→拡大率\":\"\",\"→拡大率X\":\"\",\"→拡大率Y\":\"\",\"→拡大率Z\":\"\",\"→回転X\":\"\",\"→回転Y\":\"\",\"→回転Z\":\"\",\"向き対応\":\"\",\"向き回転X\":\"true\",\"向き回転Y\":\"true\",\"向き回転R\":\"\",\"回転時間\":\"15\",\"特殊効果\":\"\",\"画面ストップ\":\"0, 0\"}"]
 * 
 * @param アニメコモン_5
 * @parent アニメコモン登録
 * @desc アニメコモンその5。どれを使ってもよい
 * @type struct<animeCommon>[]
 * @default ["{\"コモン名\":\"■マップ\",\"再生回数\":\"1\",\"開始ウェイト\":\"0\",\"中間ウェイト\":\"0\",\"レイヤー\":\"B1\",\"ズーム対応\":\"true\",\"表示範囲\":\"0\",\"位置\":\"\",\"位置ずらしX\":\"0\",\"位置ずらしY\":\"0\",\"発生\":\"\",\"発生数\":\"1\",\"発生ルート\":\"[]\",\"発生ずらしX\":\"0\",\"発生ずらしY\":\"0\",\"最初は初期位置\":\"false\",\"発生ディレイ\":\"0\",\"移動\":\"\",\"移動時間\":\"20\",\"移動ディレイ\":\"0\",\"移動X\":\"0\",\"移動Y\":\"0\",\"移動リセットX\":\"true\",\"移動リセットY\":\"true\",\"パーティクル設定\":\"\",\"拡大率\":\"\",\"拡大率X\":\"\",\"拡大率Y\":\"\",\"拡大率Z\":\"\",\"回転X\":\"\",\"回転Y\":\"\",\"回転Z\":\"\",\"速度\":\"\",\"オフセットX\":\"\",\"オフセットY\":\"\",\"下揃え\":\"false\",\"効果音-音量率\":\"\",\"効果音-ピッチ率\":\"\",\"フラッシュなし\":\"false\",\"効果音なし\":\"false\",\"パーティクル変動\":\"\",\"変動時間\":\"20\",\"変動ディレイ\":\"0\",\"→拡大率\":\"\",\"→拡大率X\":\"\",\"→拡大率Y\":\"\",\"→拡大率Z\":\"\",\"→回転X\":\"\",\"→回転Y\":\"\",\"→回転Z\":\"\",\"向き対応\":\"\",\"向き回転X\":\"false\",\"向き回転Y\":\"false\",\"向き回転R\":\"false\",\"回転時間\":\"15\",\"特殊効果\":\"\",\"画面ストップ\":\"0, 0\"}","{\"コモン名\":\"攻撃\",\"再生回数\":\"1\",\"開始ウェイト\":\"\",\"中間ウェイト\":\"\",\"レイヤー\":\"B1\",\"ズーム対応\":\"true\",\"表示範囲\":\"\",\"位置\":\"\",\"位置ずらしX\":\"-30\",\"位置ずらしY\":\"\",\"発生\":\"\",\"発生数\":\"1\",\"発生ルート\":\"\",\"発生ずらしX\":\"\",\"発生ずらしY\":\"\",\"最初は初期位置\":\"\",\"発生ディレイ\":\"\",\"移動\":\"\",\"移動時間\":\"20\",\"移動ディレイ\":\"\",\"移動X\":\"\",\"移動Y\":\"\",\"移動リセットX\":\"true\",\"移動リセットY\":\"true\",\"パーティクル設定\":\"\",\"拡大率\":\"50\",\"拡大率X\":\"\",\"拡大率Y\":\"\",\"拡大率Z\":\"\",\"回転X\":\"\",\"回転Y\":\"\",\"回転Z\":\"\",\"速度\":\"\",\"オフセットX\":\"\",\"オフセットY\":\"\",\"下揃え\":\"true\",\"効果音-音量率\":\"\",\"効果音-ピッチ率\":\"\",\"フラッシュなし\":\"true\",\"効果音なし\":\"\",\"パーティクル変動\":\"\",\"変動時間\":\"20\",\"変動ディレイ\":\"\",\"→拡大率\":\"\",\"→拡大率X\":\"\",\"→拡大率Y\":\"\",\"→拡大率Z\":\"\",\"→回転X\":\"\",\"→回転Y\":\"\",\"→回転Z\":\"\",\"向き対応\":\"\",\"向き回転X\":\"true\",\"向き回転Y\":\"true\",\"向き回転R\":\"true\",\"回転時間\":\"5\",\"特殊効果\":\"\",\"画面ストップ\":\"0, 0\"}","{\"コモン名\":\"放射\",\"再生回数\":\"1\",\"開始ウェイト\":\"\",\"中間ウェイト\":\"\",\"レイヤー\":\"B1\",\"ズーム対応\":\"true\",\"表示範囲\":\"\",\"位置\":\"\",\"位置ずらしX\":\"-30\",\"位置ずらしY\":\"-24\",\"発生\":\"\",\"発生数\":\"5\",\"発生ルート\":\"\",\"発生ずらしX\":\"\",\"発生ずらしY\":\"\",\"最初は初期位置\":\"\",\"発生ディレイ\":\"15\",\"移動\":\"\",\"移動時間\":\"50\",\"移動ディレイ\":\"\",\"移動X\":\"-100~100\",\"移動Y\":\"-10~10\",\"移動リセットX\":\"true\",\"移動リセットY\":\"true\",\"パーティクル設定\":\"\",\"拡大率\":\"25\",\"拡大率X\":\"\",\"拡大率Y\":\"\",\"拡大率Z\":\"\",\"回転X\":\"\",\"回転Y\":\"\",\"回転Z\":\"\",\"速度\":\"150\",\"オフセットX\":\"\",\"オフセットY\":\"\",\"下揃え\":\"\",\"効果音-音量率\":\"50\",\"効果音-ピッチ率\":\"\",\"フラッシュなし\":\"true\",\"効果音なし\":\"\",\"パーティクル変動\":\"\",\"変動時間\":\"50\",\"変動ディレイ\":\"\",\"→拡大率\":\"75tn\",\"→拡大率X\":\"\",\"→拡大率Y\":\"\",\"→拡大率Z\":\"\",\"→回転X\":\"360\",\"→回転Y\":\"\",\"→回転Z\":\"\",\"向き対応\":\"\",\"向き回転X\":\"true\",\"向き回転Y\":\"true\",\"向き回転R\":\"\",\"回転時間\":\"15\",\"特殊効果\":\"\",\"画面ストップ\":\"0, 0\"}","{\"コモン名\":\"放射-多\",\"再生回数\":\"1\",\"開始ウェイト\":\"\",\"中間ウェイト\":\"\",\"レイヤー\":\"B1\",\"ズーム対応\":\"true\",\"表示範囲\":\"\",\"位置\":\"\",\"位置ずらしX\":\"-30\",\"位置ずらしY\":\"-24\",\"発生\":\"\",\"発生数\":\"7\",\"発生ルート\":\"\",\"発生ずらしX\":\"\",\"発生ずらしY\":\"\",\"最初は初期位置\":\"\",\"発生ディレイ\":\"10\",\"移動\":\"\",\"移動時間\":\"30\",\"移動ディレイ\":\"\",\"移動X\":\"\",\"移動Y\":\"\",\"移動リセットX\":\"true\",\"移動リセットY\":\"true\",\"パーティクル設定\":\"\",\"拡大率\":\"50\",\"拡大率X\":\"\",\"拡大率Y\":\"\",\"拡大率Z\":\"\",\"回転X\":\"\",\"回転Y\":\"\",\"回転Z\":\"\",\"速度\":\"300\",\"オフセットX\":\"\",\"オフセットY\":\"\",\"下揃え\":\"\",\"効果音-音量率\":\"50\",\"効果音-ピッチ率\":\"\",\"フラッシュなし\":\"true\",\"効果音なし\":\"\",\"パーティクル変動\":\"\",\"変動時間\":\"30\",\"変動ディレイ\":\"\",\"→拡大率\":\"75tn\",\"→拡大率X\":\"\",\"→拡大率Y\":\"\",\"→拡大率Z\":\"\",\"→回転X\":\"360\",\"→回転Y\":\"\",\"→回転Z\":\"\",\"向き対応\":\"\",\"向き回転X\":\"true\",\"向き回転Y\":\"true\",\"向き回転R\":\"\",\"回転時間\":\"15\",\"特殊効果\":\"\",\"画面ストップ\":\"0, 0\"}"]
 * 
 * @param アニメコモン_6
 * @parent アニメコモン登録
 * @desc アニメコモンその6。どれを使ってもよい
 * @type struct<animeCommon>[]
 * @default ["{\"コモン名\":\"■背景\",\"再生回数\":\"1\",\"開始ウェイト\":\"0\",\"中間ウェイト\":\"0\",\"レイヤー\":\"B1\",\"ズーム対応\":\"true\",\"表示範囲\":\"0\",\"位置\":\"\",\"位置ずらしX\":\"0\",\"位置ずらしY\":\"0\",\"発生\":\"\",\"発生数\":\"1\",\"発生ルート\":\"[]\",\"発生ずらしX\":\"0\",\"発生ずらしY\":\"0\",\"最初は初期位置\":\"false\",\"発生ディレイ\":\"0\",\"移動\":\"\",\"移動時間\":\"20\",\"移動ディレイ\":\"0\",\"移動X\":\"0\",\"移動Y\":\"0\",\"移動リセットX\":\"true\",\"移動リセットY\":\"true\",\"パーティクル設定\":\"\",\"拡大率\":\"\",\"拡大率X\":\"\",\"拡大率Y\":\"\",\"拡大率Z\":\"\",\"回転X\":\"\",\"回転Y\":\"\",\"回転Z\":\"\",\"速度\":\"\",\"オフセットX\":\"\",\"オフセットY\":\"\",\"下揃え\":\"false\",\"効果音-音量率\":\"\",\"効果音-ピッチ率\":\"\",\"フラッシュなし\":\"false\",\"効果音なし\":\"false\",\"パーティクル変動\":\"\",\"変動時間\":\"20\",\"変動ディレイ\":\"0\",\"→拡大率\":\"\",\"→拡大率X\":\"\",\"→拡大率Y\":\"\",\"→拡大率Z\":\"\",\"→回転X\":\"\",\"→回転Y\":\"\",\"→回転Z\":\"\",\"向き対応\":\"\",\"向き回転X\":\"false\",\"向き回転Y\":\"false\",\"向き回転R\":\"false\",\"回転時間\":\"15\",\"特殊効果\":\"\",\"画面ストップ\":\"0, 0\"}","{\"コモン名\":\"バック\",\"再生回数\":\"-1\",\"開始ウェイト\":\"\",\"中間ウェイト\":\"\",\"レイヤー\":\"A1\",\"ズーム対応\":\"false\",\"表示範囲\":\"\",\"位置\":\"\",\"位置ずらしX\":\"\",\"位置ずらしY\":\"\",\"発生\":\"\",\"発生数\":\"1\",\"発生ルート\":\"\",\"発生ずらしX\":\"\",\"発生ずらしY\":\"\",\"最初は初期位置\":\"\",\"発生ディレイ\":\"\",\"移動\":\"\",\"移動時間\":\"20\",\"移動ディレイ\":\"\",\"移動X\":\"\",\"移動Y\":\"\",\"移動リセットX\":\"true\",\"移動リセットY\":\"true\",\"パーティクル設定\":\"\",\"拡大率\":\"200\",\"拡大率X\":\"\",\"拡大率Y\":\"\",\"拡大率Z\":\"\",\"回転X\":\"\",\"回転Y\":\"\",\"回転Z\":\"\",\"速度\":\"20\",\"オフセットX\":\"\",\"オフセットY\":\"\",\"下揃え\":\"\",\"効果音-音量率\":\"\",\"効果音-ピッチ率\":\"\",\"フラッシュなし\":\"true\",\"効果音なし\":\"true\",\"パーティクル変動\":\"\",\"変動時間\":\"20\",\"変動ディレイ\":\"\",\"→拡大率\":\"\",\"→拡大率X\":\"\",\"→拡大率Y\":\"\",\"→拡大率Z\":\"\",\"→回転X\":\"\",\"→回転Y\":\"\",\"→回転Z\":\"\",\"向き対応\":\"\",\"向き回転X\":\"false\",\"向き回転Y\":\"false\",\"向き回転R\":\"\",\"回転時間\":\"15\",\"特殊効果\":\"\",\"画面ストップ\":\"0, 0\"}","{\"コモン名\":\"バックフラワー\",\"再生回数\":\"-1\",\"開始ウェイト\":\"\",\"中間ウェイト\":\"60\",\"レイヤー\":\"A1\",\"ズーム対応\":\"false\",\"表示範囲\":\"\",\"位置\":\"\",\"位置ずらしX\":\"\",\"位置ずらしY\":\"\",\"発生\":\"\",\"発生数\":\"5\",\"発生ルート\":\"\",\"発生ずらしX\":\"\",\"発生ずらしY\":\"\",\"最初は初期位置\":\"\",\"発生ディレイ\":\"30~60\",\"移動\":\"\",\"移動時間\":\"20\",\"移動ディレイ\":\"\",\"移動X\":\"\",\"移動Y\":\"\",\"移動リセットX\":\"true\",\"移動リセットY\":\"true\",\"パーティクル設定\":\"\",\"拡大率\":\"40~80\",\"拡大率X\":\"\",\"拡大率Y\":\"\",\"拡大率Z\":\"\",\"回転X\":\"\",\"回転Y\":\"\",\"回転Z\":\"\",\"速度\":\"\",\"オフセットX\":\"- gw / 2 ~ gw / 2\",\"オフセットY\":\"- gh / 2 ~ gh / 2\",\"下揃え\":\"\",\"効果音-音量率\":\"\",\"効果音-ピッチ率\":\"\",\"フラッシュなし\":\"true\",\"効果音なし\":\"true\",\"パーティクル変動\":\"\",\"変動時間\":\"20\",\"変動ディレイ\":\"\",\"→拡大率\":\"\",\"→拡大率X\":\"\",\"→拡大率Y\":\"\",\"→拡大率Z\":\"\",\"→回転X\":\"\",\"→回転Y\":\"\",\"→回転Z\":\"\",\"向き対応\":\"\",\"向き回転X\":\"false\",\"向き回転Y\":\"false\",\"向き回転R\":\"\",\"回転時間\":\"15\",\"特殊効果\":\"\",\"画面ストップ\":\"0, 0\"}","{\"コモン名\":\"バックフラワー-big\",\"再生回数\":\"-1\",\"開始ウェイト\":\"\",\"中間ウェイト\":\"30\",\"レイヤー\":\"A1\",\"ズーム対応\":\"false\",\"表示範囲\":\"\",\"位置\":\"\",\"位置ずらしX\":\"\",\"位置ずらしY\":\"\",\"発生\":\"\",\"発生数\":\"10\",\"発生ルート\":\"\",\"発生ずらしX\":\"\",\"発生ずらしY\":\"\",\"最初は初期位置\":\"\",\"発生ディレイ\":\"15~30\",\"移動\":\"\",\"移動時間\":\"20\",\"移動ディレイ\":\"\",\"移動X\":\"\",\"移動Y\":\"\",\"移動リセットX\":\"true\",\"移動リセットY\":\"true\",\"パーティクル設定\":\"\",\"拡大率\":\"80~160\",\"拡大率X\":\"\",\"拡大率Y\":\"\",\"拡大率Z\":\"\",\"回転X\":\"\",\"回転Y\":\"\",\"回転Z\":\"\",\"速度\":\"\",\"オフセットX\":\"- gw / 2 ~ gw / 2\",\"オフセットY\":\"- gh / 2 ~ gh / 2\",\"下揃え\":\"\",\"効果音-音量率\":\"\",\"効果音-ピッチ率\":\"\",\"フラッシュなし\":\"true\",\"効果音なし\":\"true\",\"パーティクル変動\":\"\",\"変動時間\":\"20\",\"変動ディレイ\":\"\",\"→拡大率\":\"\",\"→拡大率X\":\"\",\"→拡大率Y\":\"\",\"→拡大率Z\":\"\",\"→回転X\":\"\",\"→回転Y\":\"\",\"→回転Z\":\"\",\"向き対応\":\"\",\"向き回転X\":\"false\",\"向き回転Y\":\"false\",\"向き回転R\":\"\",\"回転時間\":\"15\",\"特殊効果\":\"\",\"画面ストップ\":\"0, 0\"}","{\"コモン名\":\"バック-2k\",\"再生回数\":\"-1\",\"開始ウェイト\":\"\",\"中間ウェイト\":\"\",\"レイヤー\":\"\",\"ズーム対応\":\"false\",\"表示範囲\":\"\",\"位置\":\"\",\"位置ずらしX\":\"\",\"位置ずらしY\":\"\",\"発生\":\"\",\"発生数\":\"2\",\"発生ルート\":\"\",\"発生ずらしX\":\"\",\"発生ずらしY\":\"\",\"最初は初期位置\":\"\",\"発生ディレイ\":\"240\",\"移動\":\"\",\"移動時間\":\"\",\"移動ディレイ\":\"\",\"移動X\":\"\",\"移動Y\":\"\",\"移動リセットX\":\"true\",\"移動リセットY\":\"true\",\"パーティクル設定\":\"\",\"拡大率\":\"200\",\"拡大率X\":\"\",\"拡大率Y\":\"\",\"拡大率Z\":\"\",\"回転X\":\"\",\"回転Y\":\"\",\"回転Z\":\"\",\"速度\":\"20\",\"オフセットX\":\"\",\"オフセットY\":\"\",\"下揃え\":\"\",\"効果音-音量率\":\"\",\"効果音-ピッチ率\":\"\",\"フラッシュなし\":\"true\",\"効果音なし\":\"true\",\"パーティクル変動\":\"\",\"変動時間\":\"20\",\"変動ディレイ\":\"\",\"→拡大率\":\"\",\"→拡大率X\":\"\",\"→拡大率Y\":\"\",\"→拡大率Z\":\"\",\"→回転X\":\"\",\"→回転Y\":\"\",\"→回転Z\":\"\",\"向き対応\":\"\",\"向き回転X\":\"false\",\"向き回転Y\":\"false\",\"向き回転R\":\"\",\"回転時間\":\"15\",\"特殊効果\":\"\",\"画面ストップ\":\"0, 0\"}"]
 * 
 * @param アニメコモン_7
 * @parent アニメコモン登録
 * @desc アニメコモンその7。どれを使ってもよい
 * @type struct<animeCommon>[]
 * @default 
 * 
 * @param アニメコモン_8
 * @parent アニメコモン登録
 * @desc アニメコモンその8。どれを使ってもよい
 * @type struct<animeCommon>[]
 * @default 
 * 
 * @param アニメコモン_9
 * @parent アニメコモン登録
 * @desc アニメコモンその9。どれを使ってもよい
 * @type struct<animeCommon>[]
 * @default 
 * 
 *
 *
 * @command アニメ表示-マップ
 * @desc マップの好きな場所にパーティクルアニメを表示する
 *
 * @arg アニメ名
 * @desc アニメに付ける名前。アニメ消去の際の対象指定に使う
 *
 * @arg アニメファイル
 * @desc 表示するアニメファイル
 * @type animation 
 *
 * @arg 表示・移動対象
 * @desc アニメを表示する対象と移動先。キャラ、マップ位置、画面位置
 * @type struct<targetMap>
 *
 * @arg アニメ設定
 * @desc アニメの各種設定
 * @type struct<animeCfg>
 *
 * @arg …コモン使用
 * @desc アニメコモンを呼び出し、アニメ設定として使用する。呼び出しには登録したコモン名を書く
 * @type 
 * @default 
 *
 *
 *
 * @command アニメ表示-バトル
 * @desc バトルの好きな場所にパーティクルアニメを表示する
 *
 * @arg アニメ名
 * @desc アニメに付ける名前。アニメ消去の際の対象指定に使う
 *
 * @arg アニメファイル
 * @desc 表示するアニメファイル
 * @type animation 
 *
 * @arg 表示・移動対象
 * @desc アニメを表示する対象。アクター、エネミー、画面位置
 * @type struct<targetBattle>
 *
 * @arg アニメ設定
 * @desc アニメの拡大率、速度などを変更する
 * @type struct<animeCfg>
 *
 * @arg …コモン使用
 * @desc アニメコモンを呼び出し、アニメ設定として使用する。呼び出しには登録したコモン名を書く
 * @type 
 * @default 
 *
 *
 *
 * @command アニメ削除
 * @desc 表示中のパーティクルアニメを削除する
 *
 * @arg 名前で削除
 * @desc アニメ名でアニメを選択し削除する。, で区切って複数指定可能
 *
 * @arg すべて削除
 * @desc 全てのアニメを削除する
 * @type boolean
 * @default 
 */
 
 
 
//==================================================
/*~struct~animeCfg:
//==================================================
 * @param 再生回数
 * @desc アニメの再生回数。2 なら 2回。-1 なら 無限ループ
 * @default 
 *
 * @param 開始ウェイト
 * @desc アニメ開始時のウェイト。5 なら 5フレーム。演算可
 * @default 
 *
 * @param 中間ウェイト
 * @desc 再生回数が2回以上の時のアニメ再生間のウェイト。5 なら 5フレーム。演算可
 * @default 
 * 
 * @param レイヤー
 * @desc 表示レイヤー。A はキャラの下、B はキャラの上、Cはウインドウの下、Dはウインドウの上。数字が大きいほど上に表示
 * @type select
 * @option A1
 * @option A2
 * @option A3
 * @option B1
 * @option B2
 * @option B3
 * @option C1
 * @option C2
 * @option C3
 * @option D1
 * @option D2
 * @option D3
 * @default 
 *
 * @param ズーム対応
 * @desc 画面のズームに合わせて大きさを変動させる
 * @type boolean
 * @default 
 *
 * @param 表示範囲
 * @desc 表示範囲外ではアニメを表示せず軽量化する。150 なら 画面の 150% の大きさの範囲内でのみ表示。0 なら常に表示
 * @default 
 *
 * @param 位置
 *
 * @param 位置ずらしX
 * @parent 位置
 * @desc アニメ位置のXずらし幅。5 なら右に 5 ピクセル。演算可。gw:画面横幅
 * @default 
 *
 * @param 位置ずらしY
 * @parent 位置
 * @desc アニメ位置のYずらし幅。5 なら右に 5 ピクセル。演算可。gh:画面縦高
 * @default 
 *
 * @param 発生
 *
 * @param 発生数
 * @parent 発生
 * @desc アニメを発生させる数。2 なら 2個
 * @default 
 *
 * @param 発生ルート
 * @parent 発生
 * @desc アニメを複数発生させる場合の移動ルート設定
 * @type struct<ariseRoute>[]
 * @default 
 *
 * @param 発生ずらしX
 * @parent 発生
 * @desc アニメを複数発生させる場合のXずらし量。5 なら 右に 5ピクセル ずつずれていく。演算可。演算可。gw:画面横幅
 * @default 
 *
 * @param 発生ずらしY
 * @parent 発生
 * @desc アニメを複数発生させる場合のYずらし量。5 なら 下に 5ピクセル ずつずれていく。演算可。演算可。gh:画面縦高
 * @default 
 *
 * @param 最初は初期位置
 * @parent 発生
 * @desc 一発目のアニメには移動効果を適用せず、初期位置に表示する
 * @type boolean
 * @default 
 *
 * @param 発生ディレイ
 * @parent 発生
 * @desc アニメを複数発生させる場合の遅延時間。5 なら 発生を一つあたり 5フレーム ずつ遅らせる。演算可
 * @default 
 *
 * @param 移動
 *
 * @param 移動時間
 * @parent 移動
 * @desc アニメの移動時間。5 なら 5フレーム 。演算可
 * @default 
 *
 * @param 移動ディレイ
 * @parent 移動
 * @desc アニメ移動の遅延時間。5 なら移動開始を 5フレーム 遅らせる。演算可
 * @default 
 *
 * @param 移動X
 * @parent 移動
 * @desc アニメのX移動量。5 なら右に 5ピクセル。演算可。動作文字対応。gw:画面横幅
 * @default 
 *
 * @param 移動Y
 * @parent 移動
 * @desc アニメのY移動量。5 なら下に 5ピクセル。演算可。動作文字対応。gh:画面縦高
 * @default 
 *
 * @param 移動リセットX
 * @parent 移動
 * @desc アニメを繰り返す時、X方向の移動量を元に戻す
 * @type boolean
 * @default 
 *
 * @param 移動リセットY
 * @parent 移動
 * @desc アニメを繰り返す時、Y方向の移動量を元に戻す
 * @type boolean
 * @default 
 *
 * @param パーティクル設定
 *
 * @param 拡大率
 * @parent パーティクル設定
 * @desc アニメの拡大率。200 なら 200%大。演算可
 *
 * @param 拡大率X
 * @parent パーティクル設定
 * @desc アニメのX拡大率。200 なら 200%大。演算可
 *
 * @param 拡大率Y
 * @parent パーティクル設定
 * @desc アニメのY拡大率。200 なら 200%大。演算可
 *
 * @param 拡大率Z
 * @parent パーティクル設定
 * @desc アニメのZ拡大率。200 なら 200%大。演算可
 *
 * @param 回転X
 * @parent パーティクル設定
 * @desc アニメのX軸の回転角。5 なら 5度、-5 なら -5度。演算可
 *
 * @param 回転Y
 * @parent パーティクル設定
 * @desc アニメのY軸の回転角。5 なら 5度、-5 なら -5度。演算可
 *
 * @param 回転Z
 * @parent パーティクル設定
 * @desc アニメのZ軸の回転角。5 なら 5度、-5 なら -5度。演算可
 *
 * @param 速度
 * @parent パーティクル設定
 * @desc アニメの速度。200 なら 200%速。演算可
 *
 * @param オフセットX
 * @parent パーティクル設定
 * @desc アニメのX位置ずらし。5 なら右に 5ピクセル。演算可。gw:画面横幅
 *
 * @param オフセットY
 * @parent パーティクル設定
 * @desc アニメのY位置ずらし。5 なら右に 5ピクセル。演算可。gh:画面縦高
 *
 * @param 下揃え
 * @parent パーティクル設定
 * @desc アニメを下揃えにする
 * @type boolean
 * @default 
 *
 * @param 効果音-音量率
 * @parent パーティクル設定
 * @desc 効果音の音量率。50 なら元の値の 50%
 * @default
 *
 * @param 効果音-ピッチ率
 * @parent パーティクル設定
 * @desc 効果音のピッチ率。50 なら元の値の 50%
 * @default
 *
 * @param フラッシュなし
 * @parent パーティクル設定
 * @desc アニメのフラッシュをなくす
 * @type boolean
 * @default  
 *
 * @param 効果音なし
 * @parent パーティクル設定
 * @desc アニメの効果音をなくす
 * @type boolean
 * @default  
 *
 * @param パーティクル変動
 *
 * @param 変動時間
 * @parent パーティクル変動
 * @desc パーティクルの変動時間。5 なら 5フレーム 。演算可
 * @default 
 *
 * @param 変動ディレイ
 * @parent パーティクル変動
 * @desc パーティクル変動の遅延時間。5 なら移動開始を 5フレーム 遅らせる。演算可
 * @default 
 *
 * @param →拡大率
 * @parent パーティクル変動
 * @desc アニメの拡大率の変動目標。200 で 200%になる。演算可。動作文字対応
 *
 * @param →拡大率X
 * @parent パーティクル変動
 * @desc アニメのX拡大率の変動目標。200 で 200%になる。演算可。動作文字対応
 *
 * @param →拡大率Y
 * @parent パーティクル変動
 * @desc アニメのY拡大率の変動目標。200 で 200%になる。演算可。動作文字対応
 *
 * @param →拡大率Z
 * @parent パーティクル変動
 * @desc アニメのZ拡大率の変動目標。200 で 200%になる。演算可。動作文字対応
 *
 * @param →回転X
 * @parent パーティクル変動
 * @desc アニメのX軸の回転角の変動目標。5 なら 5度、-5 なら -5度になる。演算可。動作文字対応
 *
 * @param →回転Y
 * @parent パーティクル変動
 * @desc アニメのY軸の回転角の変動目標。5 なら 5度、-5 なら -5度になる。演算可。動作文字対応
 *
 * @param →回転Z
 * @parent パーティクル変動
 * @desc アニメのZ軸の回転角の変動目標。5 なら 5度、-5 なら -5度になる。演算可。動作文字対応
 *
 * @param 向き対応
 *
 * @param 向き回転X
 * @parent 向き対応
 * @desc キャラの向きに応じてアニメのX位置を回転する。左向きが基準。左向きを前提に各種数値設定をすること
 * @type boolean
 * @default 
 *
 * @param 向き回転Y
 * @parent 向き対応
 * @desc 表示キャラの向きに応じてアニメの位置を回転する。左向きが基準。左向きを前提に各種数値設定をすること
 * @type boolean
 * @default 
 *
 * @param 向き回転R
 * @parent 向き対応
 * @desc 表示キャラの向きに応じてアニメの回転角を回転する。左向きが基準。左向きを前提に各種数値設定をすること
 * @type boolean
 * @default 
 *
 * @param 回転時間
 * @parent 向き対応
 * @desc 向き回転の動作時間。5 なら 5フレーム
 * @default 
 * 
 * @param 特殊効果
 * 
 * @param 画面ストップ
 * @parent 特殊効果
 * @desc 画面を止める演出。5, 7 なら 5フレーム 待ってから 7フレーム 止める。プラグイン『Keke_HitStop』が必要
 * @default 
 */
 
 
 
//==================================================
/*~struct~animeCommon:
//==================================================
 * @param コモン名
 * @desc コモンの名前。呼び出しに使う
 * @default
 *
 * @param 再生回数
 * @desc アニメの再生回数。2 なら 2回。-1 なら 無限ループ
 * @default 1
 *
 * @param 開始ウェイト
 * @desc アニメ開始時のウェイト。5 なら 5フレーム。演算可
 * @default 
 *
 * @param 中間ウェイト
 * @desc 再生回数が2回以上の時のアニメ再生間のウェイト。5 なら 5フレーム。演算可
 * @default 
 *
 * @param レイヤー
 * @desc 表示レイヤー。A はキャラの下、B はキャラの上、Cはウインドウの下、Dはウインドウの上。数字が大きいほど上に表示
 * @type select
 * @option A1
 * @option A2
 * @option A3
 * @option B1
 * @option B2
 * @option B3
 * @option C1
 * @option C2
 * @option C3
 * @option D1
 * @option D2
 * @option D3
 * @default B1
 *
 * @param ズーム対応
 * @desc 画面のズームに合わせて大きさを変動させる
 * @type boolean
 * @default true
 *
 * @param 表示範囲
 * @desc 表示範囲外ではアニメを表示せず軽量化する。150 なら 画面の 150% の大きさの範囲内でのみ表示。0 なら常に表示
 * @default 
 * 
 * @param 位置
 *
 * @param 位置ずらしX
 * @parent 位置
 * @desc アニメ位置のXずらし幅。5 なら右に 5 ピクセル。演算可。gw:画面横幅
 * @default 
 *
 * @param 位置ずらしY
 * @parent 位置
 * @desc アニメ位置のYずらし幅。5 なら右に 5 ピクセル。演算可。gh:画面縦高
 * @default 
 *
 * @param 発生
 *
 * @param 発生数
 * @parent 発生
 * @desc アニメを発生させる数。2 なら 2個
 * @default 1
 *
 * @param 発生ルート
 * @parent 発生
 * @desc アニメを複数発生させる場合の移動ルート設定
 * @type struct<ariseRoute>[]
 * @default 
 *
 * @param 発生ずらしX
 * @parent 発生
 * @desc アニメを複数発生させる場合のXずらし量。5 なら 右に 5ピクセル ずつずれていく。演算可。演算可。gw:画面横幅
 * @default 
 *
 * @param 発生ずらしY
 * @parent 発生
 * @desc アニメを複数発生させる場合のYずらし量。5 なら 下に 5ピクセル ずつずれていく。演算可。演算可。gh:画面縦高
 * @default 
 *
 * @param 最初は初期位置
 * @parent 発生
 * @desc 一発目のアニメには移動効果を適用せず、初期位置に表示する
 * @type boolean
 * @default 
 *
 * @param 発生ディレイ
 * @parent 発生
 * @desc アニメを複数発生させる場合の遅延時間。5 なら 発生を一つあたり 5フレーム ずつ遅らせる。演算可
 * @default 
 *
 * @param 移動
 *
 * @param 移動時間
 * @parent 移動
 * @desc アニメの移動時間。5 なら 5フレーム 。演算可
 * @default 20
 *
 * @param 移動ディレイ
 * @parent 移動
 * @desc アニメ移動の遅延時間。5 なら移動開始を 5フレーム 遅らせる。演算可
 * @default 
 *
 * @param 移動X
 * @parent 移動
 * @desc アニメのX移動量。5 なら右に 5ピクセル。演算可。動作文字対応。gw:画面横幅
 * @default 
 *
 * @param 移動Y
 * @parent 移動
 * @desc アニメのY移動量。5 なら下に 5ピクセル。演算可。動作文字対応。gh:画面縦高
 * @default 
 *
 * @param 移動リセットX
 * @parent 移動
 * @desc アニメを繰り返す時、X方向の移動量を元に戻す
 * @type boolean
 * @default true
 *
 * @param 移動リセットY
 * @parent 移動
 * @desc アニメを繰り返す時、Y方向の移動量を元に戻す
 * @type boolean
 * @default true
 *
 * @param パーティクル設定
 *
 * @param 拡大率
 * @parent パーティクル設定
 * @desc アニメの拡大率。200 なら 200%大。演算可
 *
 * @param 拡大率X
 * @parent パーティクル設定
 * @desc アニメのX拡大率。200 なら 200%大。演算可
 *
 * @param 拡大率Y
 * @parent パーティクル設定
 * @desc アニメのY拡大率。200 なら 200%大。演算可
 *
 * @param 拡大率Z
 * @parent パーティクル設定
 * @desc アニメのZ拡大率。200 なら 200%大。演算可
 *
 * @param 回転X
 * @parent パーティクル設定
 * @desc アニメのX軸の回転角。5 なら 5度、-5 なら -5度。演算可
 *
 * @param 回転Y
 * @parent パーティクル設定
 * @desc アニメのY軸の回転角。5 なら 5度、-5 なら -5度。演算可
 *
 * @param 回転Z
 * @parent パーティクル設定
 * @desc アニメのZ軸の回転角。5 なら 5度、-5 なら -5度。演算可
 *
 * @param 速度
 * @parent パーティクル設定
 * @desc アニメの速度。200 なら 200%速。演算可
 *
 * @param オフセットX
 * @parent パーティクル設定
 * @desc アニメのX位置ずらし。5 なら右に 5ピクセル。演算可
 *
 * @param オフセットY
 * @parent パーティクル設定
 * @desc アニメのY位置ずらし。5 なら右に 5ピクセル。演算可
 *
 * @param 下揃え
 * @parent パーティクル設定
 * @desc アニメを下揃えにする
 * @type boolean
 * @default 
 *
 * @param 効果音-音量率
 * @parent パーティクル設定
 * @desc 効果音の音量率。50 なら元の値の 50%
 * @default
 *
 * @param 効果音-ピッチ率
 * @parent パーティクル設定
 * @desc 効果音のピッチ率。50 なら元の値の 50%
 * @default
 *
 * @param フラッシュなし
 * @parent パーティクル設定
 * @desc アニメのフラッシュをなくす
 * @type boolean
 * @default 
 *
 * @param 効果音なし
 * @parent パーティクル設定
 * @desc アニメの効果音をなくす
 * @type boolean
 * @default 
 *
 * @param パーティクル変動
 *
 * @param 変動時間
 * @parent パーティクル変動
 * @desc パーティクルの変動時間。5 なら 5フレーム 。演算可
 * @default 20
 *
 * @param 変動ディレイ
 * @parent パーティクル変動
 * @desc パーティクル変動の遅延時間。5 なら移動開始を 5フレーム 遅らせる。演算可
 * @default 
 *
 * @param →拡大率
 * @parent パーティクル変動
 * @desc アニメの拡大率の変動目標。200 で 200%になる。演算可。動作文字対応
 *
 * @param →拡大率X
 * @parent パーティクル変動
 * @desc アニメのX拡大率の変動目標。200 で 200%になる。演算可。動作文字対応
 *
 * @param →拡大率Y
 * @parent パーティクル変動
 * @desc アニメのY拡大率の変動目標。200 で 200%になる。演算可。動作文字対応
 *
 * @param →拡大率Z
 * @parent パーティクル変動
 * @desc アニメのZ拡大率の変動目標。200 で 200%になる。演算可。動作文字対応
 *
 * @param →回転X
 * @parent パーティクル変動
 * @desc アニメのX軸の回転角の変動目標。5 なら 5度、-5 なら -5度になる。演算可。動作文字対応
 *
 * @param →回転Y
 * @parent パーティクル変動
 * @desc アニメのY軸の回転角の変動目標。5 なら 5度、-5 なら -5度になる。演算可。動作文字対応
 *
 * @param →回転Z
 * @parent パーティクル変動
 * @desc アニメのZ軸の回転角の変動目標。5 なら 5度、-5 なら -5度になる。演算可。動作文字対応
 *
 * @param 向き対応
 *
 * @param 向き回転X
 * @parent 向き対応
 * @desc キャラの向きに応じてアニメのX位置を回転する。左向きが基準。左向きを前提に各種数値設定をすること
 * @type boolean
 * @default true
 *
 * @param 向き回転Y
 * @parent 向き対応
 * @desc 表示キャラの向きに応じてアニメの位置を回転する。左向きが基準。左向きを前提に各種数値設定をすること
 * @type boolean
 * @default true
 *
 * @param 向き回転R
 * @parent 向き対応
 * @desc 表示キャラの向きに応じてアニメの回転角を回転する。左向きが基準。左向きを前提に各種数値設定をすること
 * @type boolean
 * @default 
 *
 * @param 回転時間
 * @parent 向き対応
 * @desc 向き回転の動作時間。5 なら 5フレーム
 * @default 15
 * 
 * @param 特殊効果
 * 
 * @param 画面ストップ
 * @parent 特殊効果
 * @desc 画面を止める演出。5, 7 なら 5フレーム 待ってから 7フレーム 止める。プラグイン『Keke_HitStop』が必要
 * @default 0, 0
 */
 
 
 
//==================================================
/*~struct~ariseRoute:
//==================================================
 * @param ずらしX
 * @desc アニメのXずらし幅。5 なら 右に 5ピクセル ずれる。演算可。gw:画面横幅
 *
 * @param ずらしY
 * @desc アニメのYずらし幅。5 なら 下に 5ピクセル ずれる。演算可。gh:画面縦高
 *
 * @param ディレイ
 * @desc アニメの遅延時間。5 なら発生を 5フレーム 遅らせる
 */
 
 
 
//==================================================
/*~struct~targetMap:
//==================================================
 * @param 表示対象
 *
 * @param 表示キャラ-名前
 * @parent 表示対象
 * @desc 名前で対象を選択。***→イベント検索、セルフ→イベント自身、プレイヤー→プレイヤー、全て→全キャラ。, で複数選択
 *
 * @param /表示キャラ-ID
 * @parent 表示対象
 * @desc IDで対象を選択。1〜→イベントID。0→イベント自身、-1→プレイヤー、-2→全キャラ。 , で複数選択、~ でまとめて選択
 *
 * @param …位置固定
 * @parent 表示対象
 * @desc キャラに表示させたアニメの位置を固定する
 * @type select
 * @option 固定しない
 * @option マップに固定
 * @option 画面に固定
 * @default 固定しない
 * 
 * @param …可視連動
 * @parent 表示対象
 * @desc アニメの可視状態をキャラと連動する。キャラが非表示の時はアニメも非表示になる
 * @type boolean
 * @default 
 *
 * @param 表示マップX
 * @parent 表示対象
 * @desc アニメを表示するマップX位置。5 ならマップ左端から 5マス目
 *
 * @param 表示マップY
 * @parent 表示対象
 * @desc アニメを表示するマップY位置。5 ならマップ上端から 5マス目
 *
 * @param 表示画面X
 * @parent 表示対象
 * @desc アニメを表示する画面X座標。50 なら画面左端から 50ピクセル。演算可。gw:画面横幅
 *
 * @param 表示画面Y
 * @parent 表示対象
 * @desc アニメを表示する画面Y座標。50 なら画面上端から 50ピクセル。演算可。gh:画面縦高
 *
 * @param 移動先
 *
 * @param 移動時間
 * @parent 移動先
 * @desc アニメの移動時間。5 なら 5フレーム 。演算可
 * @default 
 *
 * @param 移動ディレイ
 * @parent 移動先
 * @desc アニメ移動の遅延時間。5 なら移動開始を 5フレーム 遅らせる。演算可
 * @default 
 *
 * @param 移動先キャラ-名前
 * @parent 移動先
 * @desc 名前で対象を選択。***→イベント検索、セルフ→イベント自身、プレイヤー→プレイヤー、全て→全キャラ。, で複数選択
 *
 * @param /移動先キャラ-ID
 * @parent 移動先
 * @desc IDで対象を選択。1〜→イベントID。0→イベント自身、-1→プレイヤー、-2→全キャラ。 , で複数選択、~ でまとめて選択
 *
 * @param 移動先マップX
 * @parent 移動先
 * @desc アニメを移動させるマップX位置。5 ならマップ左端から 5マス目
 *
 * @param 移動先マップY
 * @parent 移動先
 * @desc アニメを移動させるマップY位置。5 ならマップ上端から 5マス目
 *
 * @param 移動先画面X
 * @parent 移動先
 * @desc アニメを移動させる画面X座標。50 なら画面左端から 50ピクセル。演算可。gw:画面横幅
 *
 * @param 移動先画面Y
 * @parent 移動先
 * @desc アニメを移動させる画面Y座標。50 なら画面上端から 50ピクセル。演算可。gh:画面縦高
 *
 * @param 移動リセット
 * @parent 移動先
 * @desc アニメを繰り返す時、移動量を元に戻す
 * @type boolean
 * @default true
 *
 * @param 追尾モード
 * @parent 移動先
 * @desc 移動先を追尾させる。追尾する場合は追いかけ、しない場合は移動開始時のキャラの位置に向かっていく
 * @type boolean
 * @default 
 */
 
 
 
//==================================================
/*~struct~targetBattle:
//==================================================
 * @param 表示対象
 *
 * @param 表示アクター-名前
 * @parent 表示対象
 * @desc アクターを名前で選択。全て→全キャラ。, で複数選択
 *
 * @param /表示アクター-ID
 * @parent 表示対象
 * @desc アクターをIDで選択。1〜。 , で複数選択、~ でまとめて選択
 *
 * @param /表示アクター-順番
 * @parent 表示対象
 * @desc アクターを並び順で選択。1〜。 , で複数選択、~ でまとめて選択
 *
 * @param 表示エネミー-名前
 * @parent 表示対象
 * @desc エネミーを名前で選択。全て→全キャラ。, で複数選択
 *
 * @param /表示エネミー-ID
 * @parent 表示対象
 * @desc エネミーをIDで選択。1〜。 , で複数選択、~ でまとめて選択
 *
 * @param /表示エネミー-順番
 * @parent 表示対象
 * @desc エネミーを並び順で選択。1〜。 で複数選択、~ でまとめて選択
 *
 * @param 表示画面X
 * @parent 表示対象
 * @desc アニメを表示する画面X座標。50 なら画面左端から 50ピクセル。演算可。gw:画面横幅
 *
 * @param 表示画面Y
 * @parent 表示対象
 * @desc アニメを表示する画面Y座標。50 なら画面上端から 50ピクセル。演算可。gh:画面縦高
 *
 * @param 移動先
 *
 * @param 移動時間
 * @parent 移動先
 * @desc アニメの移動時間。5 なら 5フレーム 。演算可
 * @default 0
 *
 * @param 移動ディレイ
 * @parent 移動先
 * @desc アニメ移動の遅延時間。5 なら移動開始を 5フレーム 遅らせる。演算可
 * @default 0
 *
 * @param 移動先アクター-名前
 * @parent 移動先
 * @desc アクターを名前で選択。全て→全キャラ。, で複数選択
 *
 * @param /移動先アクター-ID
 * @parent 移動先
 * @desc アクターをIDで選択。1〜。 , で複数選択、~ でまとめて選択
 *
 * @param /移動先アクター-順番
 * @parent 移動先
 * @desc アクターを並び順で選択。1〜。 , で複数選択、~ でまとめて選択
 *
 * @param 移動先エネミー-名前
 * @parent 移動先
 * @desc エネミーを名前で選択。全て→全キャラ。, で複数選択
 *
 * @param /移動先エネミー-ID
 * @parent 移動先
 * @desc エネミーをIDで選択。1〜。 , で複数選択、~ でまとめて選択
 *
 * @param /移動先エネミー-順番
 * @parent 移動先
 * @desc エネミーを並び順で選択。1〜。 で複数選択、~ でまとめて選択
 *
 * @param 移動先画面X
 * @parent 移動先
 * @desc アニメを移動先する画面X座標。50 なら画面左端から 50ピクセル。演算可。gw:画面横幅
 *
 * @param 移動先画面Y
 * @parent 移動先
 * @desc アニメを移動先する画面Y座標。50 なら画面上端から 50ピクセル。演算可。gh:画面縦高
 *
 * @param 移動リセット
 * @parent 移動先
 * @desc アニメを繰り返す時、移動量を元に戻す
 * @type boolean
 * @default true
 *
 * @param 追尾モード
 * @parent 移動先
 * @desc 移動先を追尾させる。追尾する場合は追いかけ、しない場合は移動開始時のキャラの位置に向かっていく
 * @type boolean
 * @default 
 */
 
 
 
(() => {
    //- プラグイン名
    const pluginName = document.currentScript.src.match(/^.*\/(.*).js$/)[1];
    
    
    
    //==================================================
    //--  スプライト追加 /ベーシック
    //==================================================
    
    //- 破棄付きスプライト
    function SpriteKeFran() {
        this.initialize(...arguments);
    }

    SpriteKeFran.prototype = Object.create(Sprite.prototype);
    SpriteKeFran.prototype.constructor = SpriteKeFran;

    SpriteKeFran.prototype.destroy = function() {
        if (this.bitmap && !this.bitmap._url) { this.bitmap.destroy(); }
        if (!this._texture) { return; }
        Sprite.prototype.destroy.apply(this);
    };

    SpriteKeFran.prototype.endAnimation = function() {
        this._inAnimeKe = false;
    };


    //- 破棄付きスプライト-バトラー
    function SpriteKeFranBattler() {
        this.initialize(...arguments);
    }

    SpriteKeFranBattler.prototype = Object.create(Sprite_Battler.prototype);
    SpriteKeFranBattler.prototype.constructor = SpriteKeFranBattler;

    SpriteKeFranBattler.prototype.destroy = function() {
        if (this.bitmap && !this.bitmap._url) { this.bitmap.destroy(); }
        if (!this._texture) { return; }
        Sprite.prototype.destroy.apply(this);
    };

    SpriteKeFranBattler.prototype.endAnimation = function() {
        this._inAnimeKe = false;
    };

    SpriteKeFranBattler.prototype.update = function() {
        Sprite.prototype.update.call(this);
    };
    
    
    //- 独自アニメーションスプライト
    function Sprite_AnimationKeFran() {
        this.initialize(...arguments);
    };

    Sprite_AnimationKeFran.prototype = Object.create(Sprite_Animation.prototype);
    Sprite_AnimationKeFran.prototype.constructor = Sprite_AnimationKeFran;
    
    Sprite_AnimationKeFran.prototype.destroy = function(options) {
        if (!this._texture) { return; }
        Sprite_Animation.prototype.destroy.apply(this);
    };
    
    
    
    //==================================================
    //--  文字列オート変換 /ベーシック
    //==================================================
    
    // 文字列のハッシュ化
    function strToHash(str) {
        if (!str || !str.length) { return {}; }
        let hash = {};
        const strs = JSON.parse(str);
        let val = null;
        let val2 = null;
        for (let key in strs) {
            val = strs[key];
            if (!key || !val) { continue; }
            val2 = strToAuto(val, key);
            hash[key] = val2;
        }
        return hash;
    };
    
    
    // 文字列のリスト化
    function strToList(str) {
        if (!str || !str.length) { return []; }
        let array = JSON.parse(str);
        return array.map((val, i) => {
            return strToAuto(val);
        });
    };
    
    
    // 文字列の自動処理
    function strToAuto(val, key = "") {
        let val2 = null;
        let match = null;
        let end = false;
        if (!end) {
            if (val[0] == "{") {
                val2 = strToHash(val);
                end = true;
            }
        }
        if (!end) {
            if (val[0] == "[") {
                val2 = strToList(val);
                end = true;
            }
        }
        if (!end) { val = val + ","; }
        if (!end) {
            match = val.match(/^\s*(-?\d+,\s*-?\d+,\s*-?\d+,?\s*-?\d*\.?\d*)\s*,$/);
            if (match && !val.match(/[^\d\.\-,\s]/)) {
                if (key.match(/(カラー|色)/) && !key.includes("トーン") && !key.includes("ブレンド") && !key.includes("配色") && !key.includes("着色") &&  !key.includes("フラッシュ") && !key.includes("チェンジ") &&  !key.includes("選択")) {
                    val2 = "rgba(" +  match[1] + ")";
                } else {
                    val2 =  JSON.parse("[" +  match[1] + "]");
                }
                end = true;
            }
        }
        if (!end) {
            match = val.match(/(-?\d+\.?\d*),\s*/g);
            if (match && match.length >= 2 && !val.match(/[^\d\.\-,\s]/)) {
                val2 = JSON.parse("[" + match.reduce((r, s) => r + s).replace(/,$/, "") + "]");
                end = true;
            }
        }
        if (!end) {
            match = val.match(/^(true|false)\s*,/);
            if (match) {
                val2 =  match[1] == "true" ? true : false;
                end = true;
            }
        }
        if (!end) {
            match = val.match(/^(-?\d+\.?\d*)\s*,/);
            if (match && !val.match(/[^\d\.\-,\s]/)) {
                val2 = Number(match[1]); end = true;
                end = true;
            }
        }
        if (!end) {
            match = val.match(/^.+,.+/);
            if (match) {
                val2 = val.replace(/\s/g, "").split(",").filter(v => v);
                end = true;
            }
        }
        if (!end) {
            if (val[0] == "\"") { val = val.slice(1); }
            val2 = val.slice(0, -1);
        }
        return val2;
    };



    //==================================================
    //--  動的関数
    //==================================================

    let Funcs = {};

    //- ニューファンク-画面幅の演算
    function newFunc_screenW(str) {
        if (!str) { return null; }
        str = str.toString();
        if (!str.match(/(\d|gw|gh)/)) { return str; }
        str = str.replace(/(\d)[a-z]+/gi, "$1");
        str = str.replace(/[a-z]+(\d)/gi, "$1");
        const gw = Graphics.width;
        const gh = Graphics.height;
        if (!Funcs[str]) {
            Funcs[str] = new Function("gw", "gh", "return " + str);
        }
        return Math.round(Funcs[str](gw, gh));
    };
    
    
    
    //==================================================
    //--  パラメータ受け取り
    //==================================================
    
    //- 真偽化
    function toBoolean(str) {
        if (!str) { return false; }
        const str2 = str.toString().toLowerCase();
        if (str2 == "true") { return true; }
        if (str2 == "false") { return false; }
        return Number(str);
    };

    let parameters = PluginManager.parameters(pluginName);
    
    let keke_animeCommons = compileParameters(parameters, "アニメコモン登録", "アニメコモン_");

    //- パラメータの合体
    function compileParameters(parameters, word1, word2) {
        let list = strToList(parameters[word1]);
        let i = 1;
        while (parameters[word2 + i]) {
            const addList = parameters[word2 + i] ? JSON.parse(parameters[word2 + i]).map(d => JSON.parse(d)) : [];
            list = [...list, ...addList];
            i++;
        }
        return list
    };

    parameters = null;

    
    
    //==================================================
    //--  プラグインコマンド
    //==================================================
    
    
    // アニメ表示-マップ
    PluginManager.registerCommand(pluginName, "アニメ表示-マップ", args => {
        // フリーアニメの開始-マップ
        startFreeAnimeMap(args, getPlcmEvent());
    });
    
    
    // アニメ表示-バトル
    PluginManager.registerCommand(pluginName, "アニメ表示-バトル", args => {
        // フリーアニメの開始-バトル
        startFreeAnimeBattle(args, getPlcmEvent());
    });
    
    
    // アニメ削除
    PluginManager.registerCommand(pluginName, "アニメ削除", args => {
        // フリーアニメの削除
        delFreeAnime(args, getPlcmEvent());
    });
    
    
    
    //==================================================
    //--  共通開始
    //==================================================
    
    //- スプライトセット・バトル(コア追加)
    const _Spriteset_Map_initialize = Spriteset_Map.prototype.initialize;
    Spriteset_Map.prototype.initialize = function() {
        _Spriteset_Map_initialize.apply(this);
        // フリーアニメの再形成
        setTimeout(recreateFreeAnime, 50, this);
    };
    
    
    //- スプライトセット・バトル(コア追加)
    const _Spriteset_Battle_initialize = Spriteset_Battle.prototype.initialize;
    Spriteset_Battle.prototype.initialize = function() {
        _Spriteset_Battle_initialize.apply(this);
        // フリーアニメの再形成
        recreateFreeAnime(this);
    };
    
    
    //- ウインドウレイヤーの作成(コア追加)
    const _Scene_Base_createWindowLayer = Scene_Base.prototype.createWindowLayer;
    Scene_Base.prototype.createWindowLayer = function() {
        // アニメレイヤーの作成
        createAnimeLayer(this);
        _Scene_Base_createWindowLayer.apply(this);
    };
    
    
    //- シーンマップ・表示物の作成(コア追加)
    const _Scene_Map_createDisplayObjects = Scene_Map.prototype.createDisplayObjects;
    Scene_Map.prototype.createDisplayObjects = function() {
        _Scene_Map_createDisplayObjects.apply(this);
        // アニメレイヤーの作成_2
        createAnimeLayer_2(this);
    };
    
    
    //- シーンバトル・表示物の作成(コア追加)
    const _Scene_Battle_createDisplayObjects = Scene_Battle.prototype.createDisplayObjects;
    Scene_Battle.prototype.createDisplayObjects = function() {
        _Scene_Battle_createDisplayObjects.apply(this);
        // アニメレイヤーの作成_2
        createAnimeLayer_2(this);
    };
    
    
    
    //==================================================
    //--  共通更新
    //==================================================
    
    //- スプライトセット・マップ更新(コア追加)
    const _Spriteset_Map_update = Spriteset_Map.prototype.update;
    Spriteset_Map.prototype.update = function() {
        _Spriteset_Map_update.apply(this);
        // フリーアニメの更新
        updateFreeAnime();
    };
    
    
    //- スプライトセット・バトル更新(コア追加)
    const _Spriteset_Battle_update = Spriteset_Battle.prototype.update;
    Spriteset_Battle.prototype.update = function() {
        _Spriteset_Battle_update.apply(this);
        // フリーアニメの更新
        updateFreeAnime();
    };
    
    
    
    //==================================================
    //--  共通終了
    //==================================================
    
    //- スプライトセット・マップ(コア追加)
    const _Spriteset_Map_destroy = Spriteset_Map.prototype.destroy
    Spriteset_Map.prototype.destroy = function(options) {
        // スプライトの全破棄
        destroySpriteAll(this);
        _Spriteset_Map_destroy.apply(this, arguments);
    };
    
    
    //- スプライトセット・バトル(コア追加)
    const _Spriteset_Battle_destroy = Spriteset_Battle.prototype.destroy
    Spriteset_Battle.prototype.destroy = function(options) {
        // スプライトの全破棄
        destroySpriteAll(this);
        _Spriteset_Battle_destroy.apply(this, arguments);
    };
    
    
    //- スプライトの全破棄(コア追加)
    function destroySpriteAll(spriteset) {
        // アニメパック内のスプライトを破棄
        const packs = getFreeAnimePack("pre");
        if (!packs || !packs.length) { return; }
        let del = false;
        packs.forEach((pack, i) => {
            if (!pack.sprite) { return; }
            // ターゲットスプライトを破棄
            destroySprite(pack.sprite);
            pack.sprite = null;
            // アニメスプライトを破棄
            destroySprite(pack.aniSprite);
            pack.aniSprite = null;
            // パックの回数を減らす
            if (pack.num > 0) {
                pack.num--;
                // 回数がなくなったら終了
                if (!pack.num) {
                    packs[i] = null;
                    del = true;
                }
            }
            // ズームスケール値を消去
            pack.preZoomScale = null;
        });
        // null を消去
        if (del) { nullcutFreeAnimePack("pre"); }
    };
    
    
    //- スプライトの破棄(コア追加)
    function destroySprite(sprite) {
        if (!sprite) { return; }
        sprite.children.forEach(s => destroySprite(s));
        if (sprite.bitmap && !sprite.bitmap._url) { sprite.bitmap.destroy(); }
        if (sprite._texture) { sprite.destroy(); }
    };
    
    
    //- シーンマップ終了(コア追加)
    const _Scene_Map_terminate = Scene_Map.prototype.terminate;
    Scene_Map.prototype.terminate = function() {
        _Scene_Map_terminate.apply(this);
        // マップ・バトル移行時
        const nextScene = SceneManager._nextScene;
        if (nextScene.constructor.name == "Scene_Map") {
            clearFreeAnimePack();
        }
        // アニメレイヤーの破棄
        destroyAnimeLayer();
    };
    
    
    //- シーンバトル終了(コア追加)
    const _Scene_Battle_terminate = Scene_Battle.prototype.terminate;
    Scene_Battle.prototype.terminate = function() {
        _Scene_Battle_terminate.apply(this);
        // マップ移行時
        const nextScene = SceneManager._nextScene;
        if (nextScene && nextScene.constructor.name == "Scene_Map") {
            // フリーアニメパックのクリア
            clearFreeAnimePack();
        }
        // アニメレイヤーの破棄
        destroyAnimeLayer();
    };
    
    
    //- フリーアニメの削除
    function delFreeAnime(args) {
        // すべて削除
        if (toBoolean(args["すべて削除"])) {
            // フリーアニメの完全消去
            vanishFreeAnime();
            return;
        }
        // 名前で削除
        if (args["名前で削除"]) {
            const names = args["名前で削除"].replace(/\s/g, "").split(",");
            // フリーアニメの完全消去
            vanishFreeAnime(names);
        }
    };
    
    
    //- フリーアニメの完全消去
    function vanishFreeAnime(names) {
        const packs = getFreeAnimePack();
        if (!packs || !packs.length) { return; }
        let del = false;
        packs.forEach((pack, i) => {
            let delOk = !names || names.some(name => name == pack.name);
            if (!delOk) { return; }
            pack.endsInstant = true;
            pack.num = 0;
        });
    };
    
    
    
    //==================================================
    //--  共通処理
    //==================================================
    
    //- フリーアニメパックのセット
    function setFreeAnimePack(pack, timing) {
        const sm = SceneManager;
        const scene = timing == "pre" ? sm._previousScene : timing == "next" ? sm._nextScene : sm._scene;
        const gm = $gameMap;
        if (scene.constructor.name == "Scene_Map") {
            if (!gm._freeAnimePacksKeMap) { gm._freeAnimePacksKeMap = []; }
            gm._freeAnimePacksKeMap.push(pack);
            pack.scene = "map";
        } else {
            if (!gm._freeAnimePacksKeBattle) { gm._freeAnimePacksKeBattle = []; }
            gm._freeAnimePacksKeBattle.push(pack);
            pack.scene = "battle"
        }
    };
    
    
    //- フリーアニメパックの取得
    function getFreeAnimePack(timing) {
        const sm = SceneManager;
        const scene = timing == "pre" ? sm._previousScene : timing == "next" ? sm._nextScene : sm._scene;
        const gm = $gameMap;
        if (scene.constructor.name == "Scene_Map") {
            return gm._freeAnimePacksKeMap;
        } else {
            return gm._freeAnimePacksKeBattle;
        }
    };
    
    
    //- フリーアニメパックのnullカット
    function nullcutFreeAnimePack(timing) {
        const sm = SceneManager;
        const scene = timing == "pre" ? sm._previousScene : timing == "next" ? sm._nextScene : sm._scene;
        const gm = $gameMap;
        if (scene.constructor.name == "Scene_Map") {
            gm._freeAnimePacksKeMap = gm._freeAnimePacksKeMap.filter(p => p);
        } else {
            gm._freeAnimePacksKeBattle = gm._freeAnimePacksKeBattle.filter(p => p);
        }
    };
    
    
    //- フリーアニメパックのクリア
    function clearFreeAnimePack(timing) {
        const sm = SceneManager;
        const scene = timing == "pre" ? sm._previousScene : timing == "next" ? sm._nextScene : sm._scene;
        const gm = $gameMap;
        if (scene.constructor.name == "Scene_Map") {
            gm._freeAnimePacksKeMap = [];
        } else {
            gm._freeAnimePacksKeBattle = [];
        }
    };
    
    
    //- フリーアニメの取得
    function getFreeAnime(names) {
        if (!names || !names.length) { return; }
        const packs = getFreeAnimePack();
        if (!packs || !packs.length) { return; }
        const gets = [];
        packs.forEach((pack, i) => {
            if (names.some(name => name == pack.name)) { gets.push(pack); }
        });
        return gets;
    };
    
    
    //==================================================
    //--  他プラグイン連携
    //==================================================


    //- フルアニメステータスの取得
    function getFullAnimeStatus() {
        if ($gameSystem.isSideView()) { return null; }
        return $gameTemp._fullAnimeStatusKe;
    };
    
    
    //- フルアニメステータスASIの取得
    function getFullAnimeStatusAsi(battler) {
        if ($gameSystem.isSideView()) { return null; }
        if (!getFullAnimeStatus()) { return null; }
        const asi = $gameTemp.getFullAnimeStatusAsiKe(battler);
        if (!asi || !asi.faceBaseSprite) { return null; }
        return asi;
    };
    
    
    //- フルアニメステータス顔グラの取得
    function getFullAnimeStatusFace(battler) {
        if ($gameSystem.isSideView()) { return null; }
        if (!getFullAnimeStatus()) { return null; }
        const asi = $gameTemp.getFullAnimeStatusAsiKe(battler);
        if (!asi || !asi.faceBaseSprite.visible) { return null; }
        return asi.faceBaseSprite;
    };
    
    
    
    //==================================================
    //--  レイヤー
    //==================================================
    
    //- アニメレイヤーの作成
    function createAnimeLayer(scene) {
        const sceneName = scene.constructor.name;
        if (sceneName != "Scene_Map" && sceneName != "Scene_Battle") { return; }
        const spriteset = scene._spriteset;
        if (!spriteset) { return; }
        // レイヤーA
        scene._animeLayersKeA = [];
        for (let i = 0; i < 3; i++) {
            sprite = new SpriteKeFran();
            scene._animeLayersKeA[i] = sprite;
            const field = scene.constructor.name == "Scene_Map" ? spriteset._tilemap : scene.constructor.name == "Scene_Battle" ? spriteset._battleField : scene;
            field.addChildAt(sprite, 0);
            sprite.z = 0;
        };
        // レイヤーB(無効)
        /*scene._animeLayersKeB = [];
        for (let i = 0; i < 3; i++) {
            sprite = new SpriteKeFran();
            scene._animeLayersKeB[i] = sprite;
            const effectsContainer = spriteset ?  spriteset._effectsContainer : scene;
            effectsContainer.addChild(sprite);
        };*/
        // レイヤーC
        scene._animeLayersKeC = [];
        for (let i = 0; i < 3; i++) {
            sprite = new SpriteKeFran();
            scene._animeLayersKeC[i] = sprite;
            scene.addChild(sprite);
        };
    };
    
    
    //- アニメレイヤーの作成_2
    function createAnimeLayer_2(scene) {
        const spriteset = scene._spriteset;
        if (!spriteset) { return; }
        scene._animeLayersKeD = [];
        // レイヤーD
        for (let i = 0; i < 3; i++) {
            sprite = new SpriteKeFran();
            scene._animeLayersKeD[i] = sprite;
            scene.addChild(sprite);
        };
    };
    
    
    //- アニメレイヤーの破棄
    function destroyAnimeLayer() {
        const scene = SceneManager._scene;
        if (scene._animeLayersKeA) {
            scene._animeLayersKeA.forEach(layer => destroySprite(layer));
            //scene._animeLayersKeB.forEach(layer => destroySprite(layer));
            scene._animeLayersKeC.forEach(layer => destroySprite(layer));
            scene._animeLayersKeD.forEach(layer => destroySprite(layer));
        }
    };


    //- アニメのチルド
    function childAnime(aniSprite, asf, layerStr) {
        // フルアニメステータスへのチルド → 成功したらリターン
        if (childToFullAnimeStatus(aniSprite, asf)) { return; }
        // アニメスプライトのチルド
        childAnimeSprite(aniSprite, layerStr);
    };


    //- フルアニメステータスへのチルド
    function childToFullAnimeStatus(aniSprite, asf) {
        if (!$gameTemp._fullAnimeStatusKe) { return; }
        // フロントビュー時のみ
        if ($gameSystem.isSideView()) { return; }
        // フルアニメステータス顔スプライトがある時のみ
        if (!asf) { return; }
        // レイヤーを取得
        const fast = $gameTemp._fullAnimeStatusKe;
        const layer = fast._layers[fast._effectLayer];
        // チルド
        layer.addChild(aniSprite);
        return true;
    };
    
    
    //- アニメスプライトのチルド
    function childAnimeSprite(sprite, layerStr) {
        if (!sprite) { return; }
        const scene = SceneManager._scene;
        if (!scene._animeLayersKeA) { createAnimeLayer(scene); }
        // レイヤー番号を取得
        const match = layerStr.match(/(レイヤー|)([ABCD])(\d?)/);
        if (!match) { return; }
        const layerName = match[2];
        const layerNum = Number(match[3]) - 1;
        // レイヤーBの場合はエフェクトコンテナに
        if (layerName == "B") {
            scene._spriteset._effectsContainer.addChild(sprite);
            return;
        }
        // レイヤーを取得
        const layers = scene["_animeLayersKe" + layerName];
        if (!layers) { return; }
        const layer = layerName == "D" && layerNum == 2 ? scene : layers[Math.max(layerNum, 1)];
        if (!layer) { return; }
        // チルド
        layer.addChild(sprite);
    };
    
    
    
    //==================================================
    //--  フリーアニメの開始
    //==================================================
    
    //- フリーアニメの開始-マップ
    function startFreeAnimeMap(args, self) {
        const animeName = convertVariable(args["アニメ名"]);
        const animeId = Number(convertVariable(args["アニメファイル"]));
        const tages = args["表示・移動対象"] ? JSON.parse(args["表示・移動対象"]) : {};
        const posFix = convertVariable(tages["…位置固定"]);
        // アニメ設定の作成
        const animeCfg = makeAnimeConfig(args);
        const num = animeCfg ? (calcMulti(0, convertVariable(animeCfg["発生数"]))[0].val || 1) : 1;
        // 発生数パラム
        let ariseParam = { x:0, y:0, moveX:0, moveY:0, delay:0 };
        // 発生数だけ繰り返す
        for (let i = 0; i < num; i++) {
            // 発生パラムの取得
            ariseParam = getAriseParam(ariseParam, animeCfg, i);
            // 表示キャラを取得
            let charas = [...getCharasByName(convertVariable(tages["表示キャラ-名前"]), self), ...getCharasById(convertVariable(tages["/表示キャラ-ID"]), self)];
            // フリーアニメの開始-キャラ
            if (charas.length) {
                startFreeAnimeChara(animeName, animeId, tages, animeCfg, charas, posFix, ariseParam);
            }
            // フリーアニメの開始-マップ
            if (tages["表示マップX"] || tages["表示マップY"]) {
                startFreeAnimePos(animeName, animeId, tages, animeCfg, tages["表示マップX"], tages["表示マップY"], "map", ariseParam);
            }
            // フリーアニメデータの作成-画面
            if (tages["表示画面X"] || tages["表示画面Y"]) {
                startFreeAnimePos(animeName, animeId, tages, animeCfg, newFunc_screenW(tages["表示画面X"]), newFunc_screenW(tages["表示画面Y"]), "screen", ariseParam);
            }
        }
        // 画面ストップの開始
        startScreenStop(animeCfg["画面ストップ"]);
    };
    
    
    //- アニメ設定の作成
    function makeAnimeConfig(args) {
        const cfg = {};
        const commonName = convertVariable(args["…コモン使用"]);
        const animeCommon = commonName ? (keke_animeCommons.find(c => c["コモン名"] == commonName) || {}) : {};
        const animeCfg = args["アニメ設定"] ? JSON.parse(args["アニメ設定"]) : {};
        if (!Object.keys(animeCommon).length) { return animeCfg; }
        if (!Object.keys(animeCfg).length) { return animeCommon; }
        const body = Object.keys(animeCfg).length ? animeCfg : animeCommon
        Object.keys(body).forEach(key => {
            cfg[key] = animeCfg[key] || animeCommon[key];
        });
        return cfg;
    };
    
    
    //- 発生パラムの取得
    function getAriseParam(ariseParam, animeCfg, i) {
        if (!animeCfg) { return ariseParam; }
        const route = animeCfg["発生ルート"] ? JSON.parse(animeCfg["発生ルート"]) : [];
        const topBase = toBoolean(convertVariable(animeCfg["最初は初期位置"]));
        if (!(!i && topBase)) {
            // 移動ルート
            if (route && route.length) {
                const index = Math.min(i, route.length - 1);
                const poss = route[index] ? JSON.parse(route[index]) : null;
                if (poss) {
                    ariseParam.x = calcMulti(0, convertVariable(poss["ずらしX"]))[0].val || 0;
                    ariseParam.y = calcMulti(0, convertVariable(poss["ずらしY"]))[0].val || 0;
                    ariseParam.delay += calcMulti(0, convertVariable(poss["ディレイ"]))[0].val || 0;
                }
            }
            // 移動
            ariseParam.moveX += calcMulti(0, convertVariable(animeCfg["発生ずらしX"]))[0].val || 0;
            ariseParam.moveY += calcMulti(0, convertVariable(animeCfg["発生ずらしY"]))[0].val || 0;
        }
        // ディレイ
        ariseParam.delayOri = Math.round(calcMulti(0, convertVariable(animeCfg["発生ディレイ"]))[0].val || 0);
        if (i) {
            ariseParam.delay += ariseParam.delayOri;
        }
        return ariseParam;
    };
    
    
    //- フリーアニメの開始-バトル
    function startFreeAnimeBattle(args, self, targets, mirror, moveTime, moveTage) {
        const animeName = convertVariable(args["アニメ名"]);
        const animeId = Number(convertVariable(args["アニメファイル"]));
        const tages = args["表示・移動対象"] ? JSON.parse(args["表示・移動対象"]) : {};
        const posFix = convertVariable(tages["…位置固定"]);
        // アニメ設定の作成
        const animeCfg = makeAnimeConfig(args);
        const num = animeCfg ? (calcMulti(0, convertVariable(animeCfg["発生数"]))[0].val || 1) : 1;
        // 発生数パラム
        let ariseParam = { x:0, y:0, moveX:0, moveY:0, delay:0 };
        // 発生数だけ繰り返す
        for (let i = 0; i < num; i++) {
            // 発生パラムの取得
            ariseParam = getAriseParam(ariseParam, animeCfg, i);
            // 表示バトラーを取得
            const battlers = targets || [...getBattlersByName(tages["表示アクター-名前"], "actor"), ...getBattlersById(tages["/表示アクター-ID"], "actor"), ...getBattlersByIndex(tages["/表示アクター-順番"], "actor"), ...getBattlersByName(tages["表示エネミーー-名前"], "enemy"), ...getBattlersById(tages["/表示エネミー-ID"], "enemy"), ...getBattlersByIndex(tages["/表示エネミー-順番"], "enemy")];
            // フリーアニメの開始-バトラー
            if (battlers.length) {
                startFreeAnimeBattler(animeName, animeId, tages, animeCfg, battlers, false, ariseParam, mirror, moveTime, moveTage, args.toBattler);
            }
            // フリーアニメデータの作成-画面
            if (tages["表示画面X"] || tages["表示画面Y"]) {
                startFreeAnimePos(animeName, animeId, tages, animeCfg, newFunc_screenW(tages["表示画面X"]), newFunc_screenW(tages["表示画面Y"]), "screen", ariseParam);
            }
        }
        // 画面ストップの開始
        startScreenStop(animeCfg["画面ストップ"]);
    };


    //- 画面ストップの開始
    function startScreenStop(str) {
        if (!PluginManager._scripts.some(n => n == "Keke_HitStop")) { return; }
        // 画面ストップ
        $gameTemp.screenStopKe(str);
    };
    
    
    //- フリーアニメの開始-キャラ
    function startFreeAnimeChara(animeName, animeId, tages, animeCfg, charas, posFix, ariseParam, mirror, moveTime, moveTage) {
        // キャラ全てに処理
        charas.forEach(chara => {
            // 位置データの作成
            const posData = { chara:chara, posType:"chara", posFix:posFix };
            // フリーアニメの開始
            startFreeAnime(animeName, animeId, tages, animeCfg, posData, "chara", null, ariseParam, mirror, moveTime, moveTage);
        });
    };
    
    
    //- フリーアニメの開始-バトラー
    function startFreeAnimeBattler(animeName, animeId, tages, animeCfg, battlers, posFix, ariseParam, mirror, moveTime, moveTage, toBattler) {
        // キャラ全てに処理
        battlers.forEach(battler => {
            // 位置データの作成
            const posData = { battler:battler, posType:"battler" };
            // フルアニメステータス対応
            const asf = toBattler ? null : getFullAnimeStatusFace(battler);
            if (asf) { posData.asf = asf; }
            // フリーアニメの開始
            startFreeAnime(animeName, animeId, tages, animeCfg, posData, "chara", null, ariseParam, mirror, moveTime, moveTage);
        });
    };
    
    
    //- フリーアニメの開始-位置
    function startFreeAnimePos(animeName, animeId, tages, animeCfg, x, y, posType, ariseParam) {
        // 位置データの作成
        const posData = { x:x, y:y, posType:posType };
        // フリーアニメの開始
        startFreeAnime(animeName, animeId, tages, animeCfg, posData, posType, null, ariseParam);
    };
    
    
    //- フリーアニメの開始
    function startFreeAnime(animeName, animeId, tages, animeCfg, posData, type, pack, ariseParam, mirror, moveTime, moveTage) {
        // ターゲットスプライト形成
        const tageSprite = $gameParty.inBattle() ? new SpriteKeFranBattler : new SpriteKeFran();
        // フリーアニメフラグ
        tageSprite._isFreeAnimeKe = true;
        // キャラの高さを設定
        if (posData.chara) {
            const charaSprite = searchSprite(posData.chara);
            if (charaSprite && charaSprite.heigth) { tageSprite.height = charaSprite.height * charaSprite.scale.y }
        }
        // 高さがなければタイル高に
        if (!tageSprite.height) {
            tageSprite.height = $gameMap.tileHeight();
        }
        // アニメ中フラグをオン
        tageSprite._inAnimeKe = true;
        // フリーアニメパックのセット
        if (pack) {
            pack.sprite = tageSprite;
            tageSprite._packKe = pack;
        } else {
            pack = setFreeAnimePacks(tageSprite, type, animeName, animeId, tages, animeCfg, posData, ariseParam, mirror, moveTime, moveTage);
            tageSprite._packKe = pack;
        }
        // ターゲットスプライトのチルド
        childAnimeSprite(tageSprite, pack.layer);
        // アニメーションの即時形成
        createAnimationInstant(pack, animeId, animeCfg);
        // 移動パックのセット
        setMovePack(animeCfg, pack);
        // 移動先のセット
        setMoveTage(pack);
        return tageSprite;
    };
    
    
    //- フリーアニメパックスのセット
    function setFreeAnimePacks(tageSprite, type, animeName, animeId, tages, animeCfg, posData, ariseParam, mirror, moveTime, moveTage) {
        // 再生回数とウェイト
        let num = calcMulti(0, convertVariable(animeCfg["再生回数"]))[0].val || 1;
        if (num > 0) { num--; }
        let startWait = Math.round(calcMulti(0, convertVariable(animeCfg["開始ウェイト"]))[0].val || 0);
        let middleWait = Math.round(calcMulti(0, convertVariable(animeCfg["中間ウェイト"]))[0].val || 0);
        // 位置
        const offsetX = ((calcMulti(0, convertVariable(animeCfg["位置ずらしX"]))[0].val) || 0) * (mirror || 1);
        const offsetY = calcMulti(0, convertVariable(animeCfg["位置ずらしY"]))[0].val || 0;
        // レイヤー
        const layer = animeCfg["レイヤー"] || "レイヤーB1";
        // ズーム対応
        const zoomAdjust = !animeCfg["ズーム対応"] ? true : toBoolean(convertVariable(animeCfg["ズーム対応"]));
        // 表示範囲
        const scopeRate = (convertVariable(animeCfg["表示範囲"]) / 100) || 0;
        // 向き対応
        let direSpinX = false;
        let direSpinY = false;
        let direSpinR = false;
        if (posData.chara) {
            direSpinX = toBoolean(convertVariable(animeCfg["向き回転X"]));
            direSpinY = toBoolean(convertVariable(animeCfg["向き回転Y"]));
            direSpinR = toBoolean(convertVariable(animeCfg["向き回転R"]));
        }
        const spinTimeMax = calcMulti(0, convertVariable(animeCfg["回転時間"]))[0].val || 10;
        // 効果音
        const volumeRate = calcMulti(0, convertVariable(animeCfg["効果音-音量率"]))[0].val / 100 || 1;
        const pitchRate = calcMulti(0, convertVariable(animeCfg["効果音-ピッチ率"]))[0].val / 100 || 1;
        // キャラとの可視連動
        const visibleLinkChara = posData.posType == "chara" && toBoolean(tages["…可視連動"]) ? true : false;
        // パックを作成
        const pack = { sprite:tageSprite, x:0, y:0, type:type, name:animeName, animeId:animeId, tages:tages, animeCfg:animeCfg, posData:posData, num:num, startWait:startWait, middleWait:middleWait, layer:layer, zoomAdjust:zoomAdjust, scopeRate:scopeRate, offsetX:offsetX, offsetY:offsetY, offsetXori:offsetX, offsetYori:offsetY, ariseX:ariseParam.x, ariseY:ariseParam.y, ariseMoveX:ariseParam.moveX, ariseMoveY:ariseParam.moveY, ariseDelayOri:ariseParam.delayOri, ariseDelay:ariseParam.delay, ariseXori:ariseParam.x, ariseYori:ariseParam.y, ariseMoveXori:ariseParam.moveX, ariseMoveYori:ariseParam.moveY, movedX:0, movedY:0, movedToX:0, movedToY:0, chaseX:0, chaseY:0, preChaseX:0, preChaseY:0, direSpinX:direSpinX, direSpinY:direSpinY, direSpinR:direSpinR, animeDire:"" , spinTimeMax:spinTimeMax, reverseX:1, reverseY:1, spinX:0, spinY:0, volumeRate:volumeRate, pitchRate:pitchRate, isOpen:true, mirror:mirror || 1, moveTime:moveTime, moveTage:moveTage, visibleLinkChara:visibleLinkChara };
        // フリーアニメパックのセット
        setFreeAnimePack(pack);
        return pack;
    };
    
    
    //- 移動パックのセット
    function setMovePack(animeCfg, pack, preX = 0, preY = 0) {
        pack.moveTimeMax = Math.round(calcMulti(0, convertVariable(animeCfg["移動時間"]))[0].val || 20);
        pack.moveDura = pack.moveTimeMax;
        pack.moveDelayMax = Math.round(calcMulti(0, convertVariable(animeCfg["移動ディレイ"]))[0].val || 0);
        pack.moveDelay = pack.moveDelayMax;
        pack.moveResetX = !animeCfg["移動リセットX"] ? true : toBoolean(convertVariable(animeCfg["移動リセットX"]));
        pack.moveResetY = !animeCfg["移動リセットY"] ? true : toBoolean(convertVariable(animeCfg["移動リセットY"]));
        pack.moveXs = [];
        pack.moveYs = [];
        const words = ["移動X", "移動Y"];
        words.forEach(word => {
            const moves = word == "移動X" ? pack.moveXs : pack.moveYs;
            const pre =  word == "移動X" ? preX : preY;
            let rs = calcMulti(0, convertVariable(animeCfg[word] || 0));
            rs.forEach((r, i) => {
                if (!r.val) { return; }
                // 変動のセット
                const d = setDrift(moves, pre, pre + r.val, r.easing, r.easingRate);
                d.reverse = 1;
                d.spin = 0;
            });
        });
    };
    
    
    //- 移動先のセット
    function setMoveTage(pack, preX = 0, preY = 0) {
        const tages = pack.tages;
        pack.moveToXs = [];
        pack.moveToYs = [];
        if (!tages) { return; }
        // 移動時間
        pack.moveToTimeMax = Math.round(calcMulti(0, pack.moveTime)[0].val || calcMulti(0, convertVariable(tages["移動時間"]))[0].val || 0);
        pack.moveToDura = pack.moveToTimeMax;
        if (!pack.moveToTimeMax) { return; }
        pack.moveToDelayMax = Math.round(calcMulti(0, convertVariable(tages["移動ディレイ"]))[0].val || 0);
        pack.moveToDelay = pack.moveToDelayMax;
        pack.moveToReset = toBoolean(convertVariable(tages["移動リセット"]));
        pack.moveChase = pack.moveTage || toBoolean(convertVariable(tages["追尾モード"]));
         // 移動先画面
        if (tages["移動先画面X"] || tages["移動先画面Y"]) {
            // 移動先画面のセット
            setMoveToScreen(pack, tages, preX, preY);
        // 移動先マップ
        } else if (tages["移動先マップX"] || tages["移動先マップY"]) {
            // 移動先マップのセット
            setMoveToMap(pack, tages, preX, preY);
        // 移動先キャラ
        } else {
            // 移動先キャラのセット
            setMoveToChara(pack, tages, preX, preY);
        }
    };
    
    
    //- 移動先画面のセット
    function setMoveToScreen(pack, tages, preX = 0, preY = 0) {
        const screenPos = { x:calcMulti(0, convertVariable(tages["移動先画面X"]))[0].val || 0, y:calcMulti(0, convertVariable(tages["移動先画面Y"]))[0].val || 0 };
        // 位置の更新
        updatePos(pack.sprite, pack);
        // 追尾のセット
        if (pack.moveChase) {
             // 追尾の開始処理
            processChaseStart(pack);
            pack.chaseTarget = { type:"screen", x:screenPos.x, y:screenPos.y };
            return;
        }
        // 画面地点への移動距離をセット
        preX = pack.moveResetX ? 0 : preX;
        preY = pack.moveResetY ? 0 : preY;
        const goX = screenPos.x - pack.sprite.x;
        if (goX) { setDrift(pack.moveToXs, preX, preX + goX, "e", 1, "toChara"); }
        const goY = screenPos.y  - pack.sprite.y;
        if (goY) { setDrift(pack.moveToYs, preY, preY + goY, "e", 1, "toChara"); }
    };
    
    
     //- 移動先マップのセット
    function setMoveToMap(pack, tages, preX = 0, preY = 0) {
        const mapPos = { x:calcMulti(0, convertVariable(tages["移動先マップX"]))[0].val || 0, y:calcMulti(0, convertVariable(tages["移動先マップY"]))[0].val || 0 };
        // 位置の更新
        updatePos(pack.sprite, pack);
        // 追尾のセット
        if (pack.moveChase) {
             // 追尾の開始処理
            processChaseStart(pack);
            pack.chaseTarget = { type:"map", x:mapPos.x, y:mapPos.y };
            return;
        }
        // マップ地点への移動距離をセット
        preX = pack.moveResetX ? 0 : preX;
        preY = pack.moveResetY ? 0 : preY;
        const goX = screenX(mapPos.x) - pack.sprite.x;
        if (goX) { setDrift(pack.moveToXs, preX, preX + goX, "e", 1, "toChara"); }
        const goY = screenY(mapPos.y)  - pack.sprite.y;
        if (goY) { setDrift(pack.moveToYs, preY, preY + goY, "e", 1, "toChara"); }
    };
    
    
    //- 移動先キャラのセット
    function setMoveToChara(pack, tages, preX = 0, preY = 0) {
        let charaSprite = null;
        const posType = pack.posData.posType;
        // 移動先バトラーを取得
        if (posType == "battler") {
            pack.moveToChara = pack.moveTage || [...getBattlersByName(tages["移動先アクター-名前"], "actor"), ...getBattlersById(tages["/移動先アクター-ID"], "actor"), ...getBattlersByIndex(tages["/移動先アクター-順番"], "actor"), ...getBattlersByName(tages["移動先エネミー-名前"], "enemy"), ...getBattlersById(tages["/移動先エネミー-ID"], "enemy"), ...getBattlersByIndex(tages["/移動先エネミー-順番"], "enemy")][0];
            if (!pack.moveToChara) { return; }
            // フルアニメステータス対応
            const asf = getFullAnimeStatusFace(pack.moveToChara);
            // バトラースプライトを取得
            charaSprite = asf ? asf : searchSpriteBattler(pack.moveToChara);
        // 移動先キャラを取得
        } else {
            pack.moveToChara = [...getCharasByName(convertVariable(tages["移動先キャラ-名前"]), self), ...getCharasById(convertVariable(tages["/移動先キャラ-ID"]), self)][0];
            if (!pack.moveToChara) { return; }
            // キャラスプライトを取得
            charaSprite = searchSpriteChara(pack.moveToChara);
        }
        if (!charaSprite) { return; }
        // 位置の更新
        updatePos(pack.sprite, pack);
        // 追尾のセット
        if (pack.moveChase) {
            // 追尾の開始処理
            processChaseStart(pack);
            pack.chaseTarget = { type:posType, chara:pack.moveToChara };
            return;
        }
        // キャラへの移動距離をセット
        preX = pack.moveResetX ? 0 : preX;
        preY = pack.moveResetY ? 0 : preY;
        const goX = charaSprite.x - pack.sprite.x;
        if (goX) { setDrift(pack.moveToXs, preX, preX + goX, "e", 1, "toChara"); }
        const goY = charaSprite.y - pack.sprite.y;
        if (goY) { setDrift(pack.moveToYs, preY, preY + goY, "e", 1, "toChara"); }
    };
    
    
    //- 追尾の開始処理
    function processChaseStart(pack) {
        const inBattle = $gameParty.inBattle();
        // 非リセット時は追尾を移動量に代入
        if (!pack.moveToReset) {
            pack.preChaseX += pack.chaseX * (inBattle ? 1 : $gameMap.tileWidth()) || 0;
            pack.preChaseY += pack.chaseY * (inBattle ? 1 : $gameMap.tileHeight()) || 0;
        }
        const posType = pack.posData.posType;
        if (posType == "chara") {
            pack.chaseStart= { type:"chara", chara:pack.posData.chara };
        } else if (posType == "battler") {
            pack.chaseStart= { type:"battler", chara:pack.posData.battler };
        } else if (posType == "map") {
            pack.chaseStart= { type:"screen", x:canvasToMapX(pack.sprite.x), y:canvasToMapY(pack.sprite.y) };
        } else if (posType == "screen") {
            pack.chaseStart= { type:"screen", x:pack.sprite.x, y:pack.sprite.y };
        }
    };
    
    
    //- 変動のセット
    function setDrift(drifts, start, end, easing, easingRate, type) {
        const d = {};
        d.start = start || 0;
        d.end = end || 0;
        d.vol = d.end - d.start;
        d.pre = d.start;
        d.easing = easing || "e";
        d.easingRate = easingRate || 1;
        d.type = type;
        if (drifts) { drifts.push(d); }
        return d;
    };
    
    
    //- フリーアニメの再形成
    function recreateFreeAnime(spriteset) {
        const packs = getFreeAnimePack();
        if (!packs || !packs.length) { return; }
        // パックを検索
        packs.forEach((pack, i) => {
            if (!pack.num) { return; }
            // フリーアニメの開始
            pack.isOpen = true;
            pack.sprite = startFreeAnime(pack.name, pack.animeId, pack.tage, pack.animeCfg, pack.posData, pack.type, pack);
            if (pack.num > 0) { pack.num-- }
        });
    };
    
    
    
    //==================================================
    //--  アニメーション即時再生
    //==================================================
    
    //- アニメーションの即時形成
    function createAnimationInstant(pack, animeId, animeCfg, replay) {
        const spriteset = SceneManager._scene._spriteset;
        // アニメ位置の取得
        getAnimePos(pack);
        // ディレイを取得
        let delay = (pack.isOpen ? pack.startWait : pack.middleWait) + (pack.isOpen ? pack.ariseDelay || 0 : 0);
        pack.delay = delay || 0;
        // パーティクルの作成
        let animation = makeParticle(animeId, animeCfg, pack);
        // アニメーションスプライトの即時形成
        createAnimationSpriteInstant(spriteset, pack, animation, delay);
        // 開始時フラグをオフ
        pack.isOpen = false;
    };
    
    
    //- アニメーションスプライトの即時形成
    function createAnimationSpriteInstant(spriteset, pack, animation, delay) {
        const tageSprite = pack.sprite;
        const aniSprite = pack.aniSprite || new Sprite_AnimationKeFran();
        aniSprite.targetObjects = [tageSprite];
        const mirror = pack.mirror < 0 ? true : false;
        aniSprite.setup([tageSprite], animation, mirror, delay);
        // アニメのチルド
        childAnime(aniSprite, pack.posData.asf, pack.layer);
        // 変数セット
        spriteset._animationSprites.push(aniSprite);
        pack.aniSprite = aniSprite;
        // フリーアニメフラグ
        aniSprite._isFreeAnimeKe = true;
        // アニメーションのカラー変更
        if (!spriteset.isMVAnimation(animation) && PluginManager._scripts.some(n => n == "EffekseerAnimationColorChange")) {
            const tone = spriteset.parseAnimationNameColor(animation);
            if (tone) {
                aniSprite.setupColor(spriteset.getBackSprite(), tone);
                aniSprite.updateEffectsBackTexture();
            }
        }
    };
    
    
    //- アニメ位置の取得
    function getAnimePos(pack) {
        const posData = pack.posData;
        const posType = posData.posType;
        // キャラ
        if (posType == "chara") {
            const chara = posData.chara;
            const posFix = posData.posFix;
            // 位置固定の処理
            if (!posFix || posFix == "固定しない") {
                posData.posType = "chara";
            } else if (posFix == "マップに固定") {
                pack.x = chara._realX;
                pack.y = chara._realY;
                posData.posType = "map";
            } else if (posFix == "画面に固定") {
                pack.x = screenX(chara._realX);
                pack.y = screenY(chara._realY);
                posData.posType = "screen";
            }
        // マップ or スクリーン
        } else if (posType.match(/(map|screen)/i)) {
            pack.x = calcMulti(0, convertVariable(posData.x))[0].val;
            pack.y = calcMulti(0, convertVariable(posData.y))[0].val;
        }
    };
    
    
    //- 前回のキャラ移動量の取得
    function getCharaPreMove(pack) {
        let preX = 0;
        let preY = 0;
        if (!pack.moveResetX) {
            const preMove = pack.moveXs.filter(m => m.type == "toChara")[0];
            if (preMove) { preX = preMove.pre; }
        }
        if (!pack.moveResetY) {
            const preMove = pack.moveYs.filter(m => m.type == "toChara")[0];
            if (preMove) { preX = preMove.pre; }
        }
        return { x:preX, y:preY }
    };
    
    
    //- パーティクルの作成
    function makeParticle(animeId, animeCfg, pack) {
        const anime = $dataAnimations[animeId];
        if (!animeCfg || !Object.keys(animeCfg).length) { return anime; }
        // パーティクル設定
        let newAnime = copyHash(anime);
        if (animeCfg["拡大率"]) { newAnime.scale = !animeCfg["拡大率"] ? anime.scale : calcMulti(0, convertVariable(animeCfg["拡大率"]))[0].val; }
        newAnime.scaleX = newAnime.scale;
        newAnime.scaleY = newAnime.scale;
        newAnime.scaleZ = newAnime.scale;
        if (animeCfg["拡大率X"]) { newAnime.scaleX = calcMulti(0, convertVariable(animeCfg["拡大率X"]))[0].val; }
        if (animeCfg["拡大率Y"]) { newAnime.scaleY = calcMulti(0, convertVariable(animeCfg["拡大率Y"]))[0].val; }
        if (animeCfg["拡大率Z"]) { newAnime.scaleZ = calcMulti(0, convertVariable(animeCfg["拡大率Z"]))[0].val; }
        if (animeCfg["拡大率"]) { newAnime.scale = calcMulti(0, convertVariable(animeCfg["拡大率"]))[0].val || anime.scale; }
        if (animeCfg["速度"]) { newAnime.speed = calcMulti(0, convertVariable(animeCfg["速度"]))[0].val || anime.speed; }
        if (animeCfg["回転X"]) { newAnime.rotation.x = calcMulti(0, convertVariable(animeCfg["回転X"]))[0].val || anime.rotation.x; }
        if (animeCfg["回転Y"]) { newAnime.rotation.y = calcMulti(0, convertVariable(animeCfg["回転Y"]))[0].val || anime.rotation.y; }
        if (animeCfg["回転Z"]) { newAnime.rotation.z = calcMulti(0, convertVariable(animeCfg["回転Z"]))[0].val || anime.rotation.z; }
        if (animeCfg["オフセットX"]) { newAnime.offsetX = calcMulti(0, convertVariable(animeCfg["オフセットX"]))[0].val || anime.offsetX; }
        if (animeCfg["オフセットY"]) { newAnime.offsetY = calcMulti(0, convertVariable(animeCfg["オフセットY"]))[0].val || anime.offsetX; }
        if (animeCfg["下揃え"]) { newAnime.alignBotton = convertVariable(animeCfg["下揃え"], "boolean") || anime.alignBotton; }
        // オフセットXに左右反転を適用
        newAnime.offsetX *= pack.mirror;
        if (toBoolean(animeCfg["フラッシュなし"])) {
            newAnime.flashTimings = [];
        }
        if (toBoolean(animeCfg["効果音なし"])) {
            newAnime.soundTimings = [];
        }
        newAnime.displayType = 0;
        // パーティクル変動パックのセット
        setParticleDriftPack(animeCfg, pack, newAnime);
        return newAnime;
    };
    
    
    //- パーティクル変動パックのセット
    function setParticleDriftPack(animeCfg, pack, newAnime, prePack = {}) {
        pack.driftTimeMax = Math.round(calcMulti(0, convertVariable(animeCfg["変動時間"]))[0].val || 20);
        pack.driftDura = pack.driftTimeMax;
        pack.driftDelayMax = Math.round(calcMulti(0, convertVariable(animeCfg["変動ディレイ"]))[0].val || 0);
        pack.driftDelay = pack.driftDelayMax;
        words = ["→拡大率", "→拡大率X", "→拡大率Y", "→拡大率Z", "→回転X", "→回転Y", "→回転Z"];
        const keys = ["scale", "scaleX", "scaleY", "scaleZ", "rotationX", "rotationY", "rotationZ"];
        const particleDrifts = {};
        words.forEach((word, i) => {
            if (!animeCfg[word]) { return; }
            const drifts= []
            const key = keys[i];
            const pre = prePack[key] || newAnime[key] || 0;
            rs = calcMulti(pre, convertVariable(animeCfg[word]));
            rs.forEach(r => {
                if (!r.val) { return; }
                // 変動のセット
                setDrift(drifts, pre, r.val, r.easing, r.easingRate, key);
            });
            particleDrifts[key] = drifts;
        });
        pack.particleDrifts = particleDrifts;
    };
    
    
    //- フリーアニメはバトルを止めない(コア再定義)
    Spriteset_Base.prototype.isAnimationPlaying = function() {
        return this._animationSprites.length && this._animationSprites.filter(ani => !ani._isFreeAnimeKe).length > 0;
    };
    
    
    
    
    //==================================================
    //--  フリーアニメの更新
    //==================================================
    
    
    //- フリーアニメの更新
    function updateFreeAnime() {
        const packs = getFreeAnimePack();
        if (!packs || !packs.length) { return; }
        let del = false;
        packs.forEach((pack, i) => {
            // ディレイ
            if (pack.delay) {
                pack.delay--;
                return;
            } 
            const sprite = pack.sprite;
            if (!sprite) { return; }
            // アニメフラグがオフなら終了
            if (!sprite._inAnimeKe) {
                // ループする場合
                if (pack.num) {
                    // 画面範囲内か
                    checkInScreen(pack);
                    // 画面範囲外ならリターン
                    if (pack.outScreen) { return; }
                    // アニメの各種初期化
                    initAnimeEach(pack);
                    // アニメーションの即時形成
                    createAnimationInstant(pack, pack.animeId, pack.animeCfg, true);
                    // 移動の再起動
                    restartMove(pack);
                    sprite._inAnimeKe = true;
                    if (pack.num > 0) { pack.num-- }
                // しない場合
                } else {
                    // ターゲットスプライトを破棄
                    destroySprite(pack.sprite);
                    pack.sprite = null;
                    packs[i] = null;
                    del = true;
                }
                return;
            }
            // 可視連動の更新
            if (updateVisibleLink(sprite, pack)) { return; }
            // 移動の更新
            updateMove(pack);
            // 目標移動の更新
            updateToMove(pack);
            // 位置の更新
            updatePos(sprite, pack);
        });
        // null を消去
        if (del) {
            nullcutFreeAnimePack();
        }
    };


    //- 可視連動の更新
    function updateVisibleLink(sprite, pack) {
        if (!pack.visibleLinkChara) { return; }
        const posData = pack.posData;
        const chara = posData.chara;
        if (!chara) { return; }
        let hide = false;
        if ((chara._visibleKe != null && !chara._visibleKe)) { hide = true; }
        if (!chara._characterName && !chara._oneImageKe) { hide = true; }
        if (hide) {
            sprite.x = 10000;
            return true;
        }
        return false;
    };
    
    
    //- 発生パラムの再取得
    function regetAriseParam(ariseParam, animeCfg, i) {
        // 発生パラムの取得
        ariseParam = getAriseParam(ariseParam, pack.animeCfg, i);
        pack.ariseX = ariseParam.x;
        pack.ariseY = ariseParam.y;
        pack.ariseMoveX = ariseParam.moveX;
        pack.ariseMoveY = ariseParam.moveY;
        pack.ariseDelay = ariseParam.delay;
        pack.ariseXori = pack.ariseX;
        pack.ariseYori = pack.ariseY;
        pack.ariseMoveXori = ariseParam.ariseMoveX;
        pack.ariseMoveYori = ariseParam.ariseMoveY;
    };
    
    
    //- アニメの各種初期化
    function initAnimeEach(pack) {
        // 向き対応を初期化
        pack.animeDireTakeOver = pack.animeDire;
        pack.animeDire = "";
        // 回転パラメータを初期化
        pack.spinScaleX = null;
        pack.spinRotationZ = null;
        // ズーム対応を初期化
        pack.preZoomScale = null;
    };
    
    
    //- 移動の更新
    function updateMove(pack) {
        if ((!pack.moveXs.length && !pack.moveYs.length) || !pack.moveDura) { return; }
        // ディレイ
        if (pack.moveDelay) {
            pack.moveDelay--;
            return;
        }
        // カウントを減らす
        pack.moveDura--;
        // 移動量を更新
         pack.movedX = 0;
         pack.movedY = 0;
        if (pack.moveXs.length) {
            pack.movedToX = 0;
            pack.moveXs.forEach(move => {
                move.pre = applyEasing(move.pre, move.start, move.end, pack.moveDura, pack.moveTimeMax, move.easing, move.easingRate);
                const vs = getSpinX(move.pre, pack);
                pack.movedX += vs.x;
                pack.movedY += vs.y;
            });
        }
       if (pack.moveYs.length) {
            pack.movedToY = 0;
            pack.moveYs.forEach(move => {
                move.pre = applyEasing(move.pre, move.start, move.end, pack.moveDura, pack.moveTimeMax, move.easing, move.easingRate);
                const vs = getSpinY(move.pre, pack);
                pack.movedX += vs.x;
                pack.movedY += vs.y;
            });
        }
    };
    
    
    //- 目標移動の更新
    function updateToMove(pack) {
        if ((!pack.moveToXs.length && !pack.moveToYs.length && !pack.chaseTarget) || !pack.moveToDura) { return; }
        // ディレイ
        if (pack.moveToDelay) {
            pack.moveToDelay--;
            return;
        }
        // カウントを減らす
        pack.moveToDura--;
        // 移動量を更新
        pack.movedToX = 0;
        pack.movedToY = 0;
        if (pack.moveToXs.length) {
            pack.movedToX = 0;
            pack.moveToXs.forEach(move => {
                move.pre = applyEasing(move.pre, move.start, move.end, pack.moveToDura, pack.moveToTimeMax, move.easing, move.easingRate);
                pack.movedToX += move.pre;
            });
        }
       if (pack.moveToYs.length) {
            pack.movedToY = 0;
            pack.moveToYs.forEach(move => {
                move.pre= applyEasing(move.pre, move.start, move.end, pack.moveToDura, pack.moveToTimeMax, move.easing, move.easingRate);
                pack.movedToY += move.pre;
            });
        }
        // 追尾の更新
        updateChase(sprite, pack);
    };
    
    
    //- 追尾の更新
    function updateChase(sprite, pack) {
        if (!pack.moveChase) { return; }
        const volX =  getChaseTargetX(pack) - getChaseStartX(pack);
        pack.chaseX = (Math.sin(Math.PI * ((pack.moveToTimeMax - pack.moveToDura) / pack.moveToTimeMax + 1.5)) * volX + volX) / 2;
        const volY = getChaseTargetY(pack) - getChaseStartY(pack);
        pack.chaseY = (Math.sin(Math.PI * ((pack.moveToTimeMax - pack.moveToDura) / pack.moveToTimeMax + 1.5)) * volY + volY) / 2;
    };
    
    
    //- 追尾ターゲットXの取得
    function getChaseTargetX(pack) {
        const chaseTarget = pack.chaseTarget;
        if (chaseTarget.type == "chara") {
            return chaseTarget.chara._realX;
        } else if (chaseTarget.type == "battler") {
            return searchBattlerSpriteFullAnime(chaseTarget.chara).x;
        } else {
            return chaseTarget.x;
        }
    };
    
    
    //- 追尾ターゲットYの取得
    function getChaseTargetY(pack) {
        const chaseTarget = pack.chaseTarget;
        if (chaseTarget.type == "chara") {
            return chaseTarget.chara._realY;
        } else if (chaseTarget.type == "battler") {
            return searchBattlerSpriteFullAnime(chaseTarget.chara).y;
        } else {
            return chaseTarget.y;
        }
    };
    
    
    //- 追尾スタートXの取得
    function getChaseStartX(pack) {
        const chaseStart = pack.chaseStart;
        if (chaseStart.type == "chara") {
            return chaseStart.chara._realX;
        } else if (chaseStart.type == "battler") {
            return searchBattlerSpriteFullAnime(chaseStart.chara).x;
        } else {
            return chaseStart.x;
        }
    };
    
    
    //- 追尾スタートYの取得
    function getChaseStartY(pack) {
        const chaseStart = pack.chaseStart;
        if (chaseStart.type == "chara") {
            return chaseStart.chara._realY;
        } else if (chaseStart.type == "battler") {
            return searchBattlerSpriteFullAnime(chaseStart.chara).y;
        } else {
            return chaseStart.y;
        }
    };
    
    
    //- バトラースプライトの検索-フルアニメ
    function searchBattlerSpriteFullAnime(battler) {
        const asf = getFullAnimeStatusFace(battler);
        if (asf) {
            return asf || { x:0, y:0 };
        } else {
            return searchSpriteBattler(battler)|| { x:0, y:0 };
        }
    };


    //- 移動の再起動
    function restartMove(pack) {
        // 移動リセットの処理
        if (pack.moveResetX) { pack.movedX = 0; }
        if (pack.moveResetY) { pack.movedY = 0; }
        if (pack.moveToReset) {
            pack.movedToX = 0;  pack.movedToY = 0;;
            pack.chaseX = 0;  pack.chaseY = 0;
        }
        // 移動パックのセット
        setMovePack(pack.animeCfg, pack, pack.movedX, pack.movedY);
        // 移動先のセット
        setMoveTage(pack, pack.movedToX, pack.movedToY);
    };
    
    
    //- 位置の更新
    function updatePos(sprite, pack) {
        const posData = pack.posData;
        const posType = posData.posType;
        const inBattle = $gameParty.inBattle();
        // オフセットを取得
        let offsetX = 0;
        let offsetY = 0;
        let vs = getSpinX(pack.offsetX, pack);
        offsetX += vs.x;
        offsetY += vs.y;
        vs = getSpinY(pack.offsetY, pack, true);
        offsetX += vs.x;
        offsetY += vs.y;
        vs = getSpinX(pack.ariseX, pack);
        offsetX += vs.x;
        offsetY += vs.y;
        vs = getSpinY(pack.ariseY, pack);
        offsetX += vs.x;
        offsetY += vs.y;
        vs = getSpinX(pack.ariseMoveX, pack);
        offsetX += vs.x;
        offsetY += vs.y;
        vs = getSpinY(pack.ariseMoveY, pack);
        offsetX += vs.x;
        offsetY += vs.y;
        // キャラ位置
        if (posType == "chara") {
            const chara = posData.chara;
            sprite.x = screenX(chara._realX + (pack.movedX + pack.movedToX) / $gameMap.tileWidth());
            sprite.y = screenY(chara._realY + (pack.movedY + pack.movedToY) / $gameMap.tileHeight());
        // バトラー位置
        } else if (posType == "battler") {
            const battler = posData.battler;
            const asf = posData.asf;
            const battlerSprite = asf ? asf : searchSpriteBattler(battler);
            const battlerH = battlerSprite._frame.height * battlerSprite.scale.y;
            if (battlerSprite && battlerSprite.parent) { 
                sprite.x = battlerSprite.x + pack.movedX + pack.movedToX;
                sprite.y = battlerSprite.y + pack.movedY + pack.movedToY - battlerH / 2;
                // 画面からはみ出させない
                /*const gh = Graphics.height;
                const battlerH = battlerSprite._frame.height * sprite.scale.y;
                // 端の座標を取得
                const upEdge = battlerSprite.y - battlerH;
                const downEdge = battlerSprite.y;
                // 上
                if (upEdge < 0) {
                    sprite.y += 0 - upEdge;
                // 下
                } else if (downEdge > gh) {
                    sprite.y -= downEdge - gh;
                }*/
            }
        // マップ位置
        } else if (posType == "map") {
            sprite.x = screenX(pack.x + (pack.movedX + pack.movedToX) / $gameMap.tileWidth());
            sprite.y = screenY(pack.y + (pack.movedY + pack.movedToY) / $gameMap.tileWidth());
        // 画面位置
        } else if (posType == "screen") {
            sprite.x = pack.x + pack.movedX + pack.movedToX;
            sprite.y = pack.y + pack.movedY + pack.movedToY;
            // ズーム画面固定
            //const zoomOffset = getZoomScreenFix(sprite);
            //sprite.x += zoomOffset.x;
            //sprite.y += zoomOffset.y;
        }
        sprite.x += offsetX + pack.chaseX * (inBattle ? 1 : $gameMap.tileWidth()) + pack.preChaseX;
        sprite.y += offsetY + pack.chaseY * (inBattle ? 1 : $gameMap.tileHeight()) + pack.preChaseY;
        //sprite.visible = false;
    };
    
    
    
    //==================================================
    //--  フリーアニメの状態更新
    //==================================================
    
    //- フリーアニメの状態更新 追加(コア追加)
    const _Sprite_Animation_update = Sprite_Animation.prototype.update;
    Sprite_Animation.prototype.update = function() {
        // フリーアニメの状態更新
        updateFreeAnimeState(this, this._targets[0]);
        _Sprite_Animation_update.apply(this);
    };
    
    
    //- フリーアニメの状態更新
    function updateFreeAnimeState(aniSprite, tageSprite) {
        if (!tageSprite || !tageSprite._isFreeAnimeKe || !aniSprite._effect) { return; }
        const pack = tageSprite._packKe;
        // アニメの即終了
        endAnimeInstant(aniSprite, pack);
        // 画面範囲内か
        checkInScreen(pack, aniSprite, true);
        // パーティクルの変動
        driftParticle(aniSprite, tageSprite, pack);
        // 向き対応の更新
        updateAdjustDire(aniSprite, tageSprite, pack);
        // 回転変動の更新
        updateSpinDrift(aniSprite, tageSprite, pack);
        // 回転パラメータの更新
        updateSpinParam(aniSprite, tageSprite, pack);
        // ズーム対応
        adjustZoom(aniSprite, tageSprite, pack);
    };
    
    
    //- 画面範囲内か
    function checkInScreen(pack, aniSprite, inAnime) {
        if (!pack.scopeRate) { return; }
        let result = true;
        const sprite = pack.sprite;
        // 位置の更新
        updatePos(sprite, pack);
        // 画面内か判定
        const gw = Graphics.width;
        const gh = Graphics.height;
        const zoomRate = 1 / $gameScreen.zoomScale();
        const scopeRate = pack.scopeRate * zoomRate;
        const plusRate = (scopeRate - 1) / 1 + 1;
        const minusRate = (scopeRate - 1) / 1;
        if (sprite.x < -gw * minusRate || sprite.x > gw * plusRate || sprite.y < -gh *minusRate || sprite.y > gh * plusRate) { result = false; }
        // アニメ中に範囲外になったとき
        if (!result && inAnime) {
            // アニメ即終了を予約
            pack.endsInstant = true;
            // 画面外フラグをオン
            pack.outScreen = true; 
        }
        // 待機中に範囲内になったとき
        if (!inAnime && result) {
            setTimeout(omitOutScreen, 50, getPacksByPack(pack));
        }
        return result;
    };
    
    
    //- パックからのパックス取得
    function getPacksByPack(pack) {
        if (pack.scene == "map") {
            return $gameMap._freeAnimePacksKeMap;
        } else {
            return $gameMap._freeAnimePacksKeBattle;
        }
    };


    //- 画面外フラグの解除
    function omitOutScreen(packs) {
        if (!packs) { return; }
        packs.forEach(p => {
            if (!p) { return; }
            p.outScreen = false;
        }); 
    };
    
    
    // パーティクルの変動
    function driftParticle(aniSprite, tageSprite, pack) {
        if (!pack.driftDura) { return; }
        // ディレイ
        if (pack.delay) { return; }
        if (pack.driftDelay) {
            pack.driftDelay--;
            return;
        }
        // カウントを減らす
        pack.driftDura--;
        const particleDrifts = pack.particleDrifts;
        const animation = aniSprite._animation;
        Object.keys(particleDrifts).forEach(key => {
            const drifts = particleDrifts[key];
            if (!drifts || !drifts.length) { return; }
            drifts.forEach(drift => {
                drift.pre = applyEasing(drift.pre, drift.start, drift.end, pack.driftDura, pack.driftTimeMax, drift.easing, drift.easingRate);
                // スケール
                if (key.includes("scale")) {
                    if (key == "scale") {
                        animation["scaleX"] = drift.pre;
                        animation["scaleY"] = drift.pre;
                        animation["scaleZ"] = drift.pre;
                    } else {
                        animation[key] = drift.pre;
                    }
                     // ズームスケールを取得
                     const zoomScale = $gameScreen.zoomScale();
                     if (zoomScale != 1 && pack.zoomAdjust) { aniSprite._animation[key] *= zoomScale; }
                // 回転
                } else {
                    if (key.includes("X")) {
                        animation.rotation.x = drift.pre;
                    } else if (key.includes("Y")) {
                        animation.rotation.y = drift.pre;
                    } else {
                        animation.rotation.z = drift.pre;
                    }
                }
            });
        });
    };
    
    
    //- ズーム対応
    function adjustZoom(aniSprite, tageSprite, pack) {
        if (!pack.zoomAdjust) { return; }
        // ディレイ
        if (pack.delay) { return; }
        const animation = aniSprite._animation;
        // 前回のスケールを戻す
        if (pack.preZoomScale) {
            animation.scale /= pack.preZoomScale;
            animation.scaleX /= pack.preZoomScale;
            animation.scaleY /= pack.preZoomScale;
            animation.scaleZ /= pack.preZoomScale;
            animation.offsetX /= pack.preZoomScale;
            animation.offsetY /= pack.preZoomScale;
            animation.offsetXori /= pack.preZoomScale;
            animation.offsetYori /= pack.preZoomScale;
            pack.preZoomScale = null;
        }
        // ズームスケールを取得
        const zoomScale = $gameScreen.zoomScale();
        if (zoomScale == 1) { return; }
        // スケールを適用
        pack.preZoomScale = $gameScreen.zoomScale();
        animation.scale *= pack.preZoomScale;
        animation.scaleX *= pack.preZoomScale;
        animation.scaleY *= pack.preZoomScale;
        animation.scaleZ *= pack.preZoomScale;
        animation.offsetX *= pack.preZoomScale;
        animation.offsetY *= pack.preZoomScale;
        animation.offsetXori *= pack.preZoomScale;
        animation.offsetYori *= pack.preZoomScale;
    };
    
    
    //- ズーム画面固定値の取得
    function getZoomScreenFix(sprite) {
        const gs = $gameScreen;
        const zoomScale = gs.zoomScale();
        if (zoomScale == 1) { return { x:0, y:0 }; }
        const rate = 1 / zoomScale;
        const offsetX = (sprite.x - gs.zoomX()) * (rate - 1);
        const offsetY = (sprite.y - gs.zoomY()) * (rate - 1);
        return { x:offsetX, y:offsetY };
    };
    
    
    //- アニメの拡大率XYZを追加
    const _Sprite_Animation_updateEffectGeometry = Sprite_Animation.prototype.updateEffectGeometry
    Sprite_Animation.prototype.updateEffectGeometry = function() {
        _Sprite_Animation_updateEffectGeometry.apply(this);
        if (this._handle && (this._animation.scaleX || this._animation.scaleY || this._animation.scaleZ || this._animation.scale)) {
            const scale = this._animation.scale / 100;
            const scaleX = (this._animation.scaleX / 100) || scale;
            const scaleY = (this._animation.scaleY / 100) || scale;
            const scaleZ = (this._animation.scaleZ / 100) || scale;
            this._handle.setScale(scaleX, scaleY, scaleZ);
        }
    };
    
    
    // サウンド変更
    const _Sprite_Animation_processSoundTimings = Sprite_Animation.prototype.processSoundTimings;
    Sprite_Animation.prototype.processSoundTimings = function() {
        if (this._isFreeAnimeKe) {
            const pack = this._targets[0]._packKe;
            for (const timing of this._animation.soundTimings) {
                if (timing.frame === this._frameIndex) {
                    AudioManager.playSe(overwriteSe(timing.se, pack));
                }
            }
            return;
        }
        _Sprite_Animation_processSoundTimings.apply(this);
    };
    
    
    //- 効果音の上書き
    function overwriteSe(se, pack) {
        newSe = {};
        newSe.name = se.name;
        newSe.volume = se.volume * pack.volumeRate;
        newSe.pitch = se.volume * pack.pitchRate;
        newSe.pan = se.pan;
        return newSe;
    };
    
    
    //- 向き対応の更新
    function updateAdjustDire(aniSprite, tageSprite, pack) {
        if (!pack.posData.chara || $gameParty.inBattle()) { return; }
        //- 向き対応の引き継ぎ
        takeOverAdjustDire(aniSprite, pack);
        const chara = pack.posData.chara;
        const animeDire = pack.animeDire;
        switch(chara._direction) {
            // 左
            case 4:
                if (pack.direSpinX && animeDire != "left") {
                    // アニメ向きの回転-左
                    spinAnimeDireLeft(aniSprite, pack);
                    pack.animeDire = "left";
                }
                break;
            // 右
            case 6:
                if (pack.direSpinX && animeDire != "right") {
                    // アニメ向きの回転-右
                    spinAnimeDireRight(aniSprite, pack);
                    pack.animeDire = "right";
                }
                break;
            // 上
            case 8:
                if (pack.direSpinY && animeDire != "up") {
                    // アニメ向きの回転-上
                    spinAnimeDireUp(aniSprite, pack);
                    pack.animeDire = "up";
                }
                break;
            // 下
            case 2:
                if (pack.direSpinY && animeDire != "down") {
                    // アニメ向きの回転-下
                    spinAnimeDireDown(aniSprite, pack);
                    pack.animeDire = "down";
                }
                break;
        }
    };
    
    
    //- 向き対応の引き継ぎ
    function takeOverAdjustDire(aniSprite, pack) {
        if (!pack.animeDireTakeOver) { return; }
        switch(pack.animeDireTakeOver) {
            // 左
            case "left":
                // アニメ向きの回転-左
                spinAnimeDireLeft(aniSprite, pack);
                break;
            // 右
            case "right":
                // アニメ向きの回転-右
                spinAnimeDireRight(aniSprite, pack);
                break;
            // 上
            case "up":
                // アニメ向きの回転-上
                spinAnimeDireUp(aniSprite, pack);
                break;
            // 下
            case "down":
                // アニメ向きの回転-下
                spinAnimeDireDown(aniSprite, pack);
                break;
        }
        pack.animeDireTakeOver = null;
    };
    
    
    //- アニメ向きの回転-左
    function spinAnimeDireLeft(aniSprite, pack) {
        const animation = aniSprite._animation;
        // アニメ回転変動の初期化
        initSpinDrift(pack);
        drifts = pack.spinDrifts;
        // 回転パラメータを変動セット
        setDrift(drifts.reverseX, pack.reverseX, 1, "e", 1);
        setDrift(drifts.spinX, pack.spinX, 0, "e", 1);
        setDrift(drifts.reverseY, pack.reverseY, 1, "e", 1);
        setDrift(drifts.spinY, pack.spinY, 0, "e", 1);
    };
    
    
    //- アニメ向きの回転-右
    function spinAnimeDireRight(aniSprite, pack) {
        const animation = aniSprite._animation;
        // アニメ回転変動の初期化
        initSpinDrift(pack);
        drifts = pack.spinDrifts;
        // 回転パラメータを変動セット
        setDrift(drifts.reverseX, pack.reverseX, -1, "e", 1);
        setDrift(drifts.spinX, pack.spinX, 0, "e", 1);
        setDrift(drifts.reverseY, pack.reverseY, 1, "e", 1);
        setDrift(drifts.spinY, pack.spinY, 0, "e", 1);
    };
    
    
    //- アニメ向きの回転-上
    function spinAnimeDireUp(aniSprite, pack) {
        const animation = aniSprite._animation;
        // アニメ回転変動の初期化
        initSpinDrift(pack);
        drifts = pack.spinDrifts;
        // 回転パラメータを変動セット
        setDrift(drifts.reverseX, pack.reverseX, 1, "e", 1);
        setDrift(drifts.spinX, pack.spinX, 1, "e", 1);
        setDrift(drifts.reverseY, pack.reverseY, 1, "e", 1);
        setDrift(drifts.spinY, pack.spinY, -1, "e", 1);
    };
    
    
    //- アニメ向きの回転-下
    function spinAnimeDireDown(aniSprite, pack) {
        const animation = aniSprite._animation;
        // アニメ回転変動の初期化
        initSpinDrift(pack);
        drifts = pack.spinDrifts;
        // 回転パラメータを変動セット
        setDrift(drifts.reverseX, pack.reverseX, 1, "e", 1);
        setDrift(drifts.spinX, pack.spinX, -1, "e", 1);
        setDrift(drifts.reverseY, pack.reverseY, 1, "e", 1);
        setDrift(drifts.spinY, pack.spinY, 1, "e", 1);
    };
    
    
    // 回転変動の初期化
    function initSpinDrift(pack) {
        pack.spinTimeMax = pack.spinTimeMax;
        pack.spinDura = !pack.animeDire ? 1 : pack.spinTimeMax;
        pack.spinDrifts = {};
        const drifts = pack.spinDrifts;
        drifts.reverseX = [];
        drifts.reverseY = [];
        drifts.spinX = [];
        drifts.spinY = [];
    };
    
    
    // 回転変動の更新
    function updateSpinDrift(aniSprite, tageSprite, pack) {
        if (!pack.spinDura) { return; }
        // カウントを減らす
        pack.spinDura--;
        Object.keys(pack.spinDrifts).forEach((key, i) => {
            const drifts = pack.spinDrifts[key];
            if (!drifts.length) { return; }
            const drift = drifts[0];
            switch (key) {
                case "reverseX":
                    pack.reverseX = applyEasing(drift.pre, drift.start, drift.end, pack.spinDura, pack.spinTimeMax, drift.easing, drift.easingRate);
                    break;
                case "reverseY":
                    pack.reverseY = applyEasing(drift.pre, drift.start, drift.end, pack.spinDura, pack.spinTimeMax, drift.easing, drift.easingRate);
                    break;
                case "spinX":
                    pack.spinX = applyEasing(drift.pre, drift.start, drift.end, pack.spinDura, pack.spinTimeMax, drift.easing, drift.easingRate);
                    break;
                case "spinY":
                    pack.spinY = applyEasing(drift.pre, drift.start, drift.end, pack.spinDura, pack.spinTimeMax, drift.easing, drift.easingRate);
                    break;
            }
        });
    };
    
    
    //- 回転値Xの取得
    function getSpinX(v, pack, onlyRvs) {
        const r = { x:0, y:0 }
        if (pack.spinY && !onlyRvs) {
            r.y = v * pack.spinX;
            r.x = v * (1 - Math.abs(pack.spinX)) * pack.reverseX * pack.mirror;
        } else {
            r.x = v * pack.reverseX * pack.mirror;
        }
        return r;
    };
    
    
    //- 回転値Yの取得
    function getSpinY(v, pack, onlyRvs) {
        const r = { x:0, y:0 }
        if (pack.spinY && !onlyRvs) {
            r.x = v * pack.spinY;
            r.y = v * (1 - Math.abs(pack.spinY)) * pack.reverseY;
        } else {
            r.y = v * pack.reverseY;
        }
        return r;
    };
    
    
    // 回転パラメータの更新
    function updateSpinParam(aniSprite, tageSprite, pack) {
        if (!pack.direSpinR) { return; }
        const animation = aniSprite._animation;
        if (pack.spinScaleX) { animation.scaleX /= pack.spinScaleX; }
        if (pack.spinRotationZ) { animation.rotation.z -= pack.spinRotationZ; }
        pack.spinScaleX = pack.reverseX;
        pack.spinRotationZ = pack.spinY > 0 ? Math.round(90 * pack.spinY) : pack.spinY < 0 ? Math.round(270 * Math.abs(pack.spinY)) : 0;
        animation.scaleX *= pack.spinScaleX;
        animation.rotation.z += pack.spinRotationZ;
    };
    
    
    
    //==================================================
    //--  フリーアニメの終了
    //==================================================
    
     // スプライト・アニメーションの破棄
    const _Sprite_Animation_destroy = Sprite_Animation.prototype.destroy;
    Sprite_Animation.prototype.destroy = function(options) {
        // 回数が残っていたらストップだけ
        const tageSprite = this._targets[0];
        if (tageSprite && tageSprite._isFreeAnimeKe) {
            const pack = tageSprite._packKe;
            if (pack.num) {
                // アニメーションの停止
                stopAnimation(this, pack);
               
                return;
            }
        }
        if (!this._texture) { return; }
        _Sprite_Animation_destroy.apply(this, arguments);
    };
    
    
    //- アニメーションの停止
    function stopAnimation(aniSprite, pack) {
        if (aniSprite._handle) {  aniSprite._handle.stop(); }
        aniSprite._handle = null;
        aniSprite._playing = false;
        aniSprite._started = false;
        aniSprite._frameIndex = 0;
        aniSprite._flashColor = [0, 0, 0, 0];
        aniSprite._flashDuration = 0;
    };
    
    
    //- アニメの即終了
    function endAnimeInstant(aniSprite, pack) {
        if (!pack.endsInstant) { return; }
        // アニメーションの停止
        stopAnimation(aniSprite, pack);
        pack.isOpen = true;
        pack.delay = 0;
        pack.getsAriseDelay = true;
        pack.endsInstant = false;
    };
    
    
    
    //==================================================
    //--  フリーアニメ・スキル
    //==================================================
    
    //- フリーアニメ・スキルの実行 呼び出し
    const _Window_BattleLog_showAnimation = Window_BattleLog.prototype.showAnimation;
    Window_BattleLog.prototype.showAnimation = function(
    subject, targets, animationId) {
        // フリーアニメ・スキルの実行
        doFreeAnimeSkill(subject, targets);
        _Window_BattleLog_showAnimation.apply(this, arguments);
    };
    
    
    //- フリーアニメ・スキルの実行
    function doFreeAnimeSkill(subject, targets) {
        const bm = BattleManager;
        const action = bm._action;
        // アニメファイルとコモンを取得
        const obje = action.item();
        const metaList = metaAll(obje.note, ["フリーアニメ", "freeAnime"]);
        if (!metaList || !metaList.length) { return; }
        metaList.forEach(meta => {
            // フリーアニメ・スキルの実行-個別
            BattleManager.doFreeAnimeSkillKe(meta, subject, targets);
        });
    };
    
    
    //- フリーアニメ・スキルの実行-個別
    BattleManager.doFreeAnimeSkillKe = function(meta, subject, targets, toBattler) {
        const metas = meta.replace(/\s/g, "").split(",");
        if (metas.length < 2) { return; }
        // パラメータ取得
        const file = Number(metas[0]);
        const commonName = metas[1];
        // 移動時間
        let moveTime = metas[2];
        // ウェイト
        const wait = Number(metas[3]);
        // 1回だけの処理
        const once = Number(metas[4]);
        if (once) {
            if (!subject._didFreeAnimeSkillsKe) { subject._didFreeAnimeSkillsKe = []; }
            if (subject._didFreeAnimeSkillsKe.some(didMeta => didMeta == meta)) {
                return;
            } else {
                subject._didFreeAnimeSkillsKe.push(meta);
            }
        }
        // ターゲットを判定
        let moveTages = null;
        // 移動時間がある場合
        if (Number(moveTime)) {
            // 行動者対象の場合
            if (moveTime == -1) {
                targets = [subject];
                moveTime = 0;
            // 移動する場合
            } else {
                const targets2 = targets;
                targets = [subject];
                moveTages = targets2;
            }
        }
        // アルグスを作成
        const args = {};
        args["アニメファイル"] = file;
        args["…コモン使用"] = commonName;
        args.toBattler = toBattler;
        // フリーアニメ・スキルの開始
        if (wait) {
            const time = Math.round(wait * 1000 / 60);
            setTimeout(startFreeAnimeSkill, time, args, targets, moveTime, moveTages);
        } else {
            startFreeAnimeSkill(args, targets, moveTime, moveTages);
        }
    };
    
    
    //- フリーアニメ・スキルの開始
    function startFreeAnimeSkill(args, targets, moveTime, moveTages) {
        if (!targets[0]) { return; }
        const spriteset = SceneManager._scene._spriteset;
        // フリーアニメの開始-バトル
        if (!moveTages) {
            const mirror = spriteset.animationShouldMirror(targets[0]) ? -1 : 1;
            startFreeAnimeBattle(args, null, targets, mirror);
        } else {
            moveTages.forEach(moveTage => {
                const mirror = spriteset.animationShouldMirror(moveTage) ? -1 : 1;
                startFreeAnimeBattle(args, null, targets, mirror, moveTime, moveTage);
            });
        }
    };


    //- エンドアクション時にフリーアニメスキル禁止を解除(コア追加)
    /*const _BattleManager_endAction = BattleManager.endAction;
    BattleManager.endAction = function() {
        this._subject._didFreeAnimeSkillsKe = null;
        _BattleManager_endAction.apply(this);
    };*/


    //- スタートアクションにフリーアニメスキル実行済みフラグを解除(コア追加)
    const _BattleManager_startAction = BattleManager.startAction;
    BattleManager.startAction = function() {
        this._subject._didFreeAnimeSkillsKe = null;
        _BattleManager_startAction.apply(this);
    };
    
    
    
    //==================================================
    //--  計算基本 /ベーシック
    //==================================================
    
    //- マルチ演算
    function calcMulti(cur, tage, ori, cmds = {}) {
        if (tage == null) { return [{}]; }
        const datas = [cur, tage.toString(), ori, cmds];
        cur = cur || 0;
        let tageStr = tage.toString();
        // 画面横幅/縦高を変換
        const matches = tageStr.match(/[\s\d\.\+\-\*\/\%\(\)]*(gw|gh)[\s\d\.\+\-\*\/\%\(\)]*/gi);
        if (matches) {
            matches.forEach(formula => {
                const v = newFunc_screenW(formula);
                tageStr = tageStr.replace(formula, v.toString());
            });
        }
        let tageLine = tageStr.split(",");
        tageLine = tageLine.map(v => v.replace(/\s/g, ""));
        let sols = [];
        tageLine.forEach((tages, i) => {
            const match = tages.match(/^(r*m*s*\/|)\s*([\+\*\/\%\=↑↓←→]*)\s*(\-*\s*\d+\.*\d*)\s*~*(\-*\s*\d*\.*\d*)\s*([\+\*\/\%\=←→↑↓]*)\s*(tn|cg|fk|cf|rd|bk|ei|eo|e|en|)\s*(\(*\-*\s*\d*\.*\d*\)*)\s*(&*b*j*d*c*t*o*)\s*(\_*\-*\s*\d*\.*\d*)$/i);
            if (!match) {
                sols.push({ val:tages, header:"", easing:"", easingRate:1, extra:"", num:0, datas:datas });
                return;
            }
            let val = 0;
            let rvs = 1;
            let header = "";
            let easing = "";
            let easingRate = 1;
            let extra = "";
            let num = 1;
            if (match[1]) {
                header = match[1].replace(/\//g, "").toUpperCase();
                if (header.match(/r/i)) { rvs = -1; }
            }
            if (match[6]) {
                easing = match[6].toUpperCase();
            }
            if (match[7]) {
                const mt = match[7].match(/\-*\d+\.*\d*/);
                easingRate = mt ? Number(mt[0]) : 1;
            }
            if (match[8]) {
                extra = match[8].replace(/&/g, "").toUpperCase();
            }
            if (match[9]) {
                num = Number(match[9].replace(/\_/g, ""));
            }
            if (match[4]) {
                const vs = [Number(match[3]), Number(match[4])];
                vs.sort((a, b) => a - b);
                v = vs[0] + Math.random() * (vs[1] - vs[0]);
            } else {
                v = Number(match[3]);
            }
            const symbol = (match[2] || "") + (match[5] || "");
            if (cmds.noMinus && !symbol && v < 0) {
                symbol = "+";
            }
            if (symbol.includes("+")) {
                val = Number(cur) + v * rvs;
            } else if (symbol.includes("*")) {
                val = Number(cur) * v * rvs;
            } else if (symbol.includes("/")) {
                val = Number(cur) / v * rvs;
            } else if (symbol.includes("%")) {
                val = Number(cur) % v * rvs;
            } else if (symbol.includes("←")) {
                val = Number(cur) - v * rvs;
            } else if (symbol.includes("→")) {
                val = Number(cur) + v * rvs;
            } else if (symbol.includes("↑")) {
                val = Number(cur) - v * rvs;
            } else if (symbol.includes("↓")) {
                val = Number(cur) + v * rvs;
            } else {
                val = v * rvs;
                if (ori && !symbol.includes("=")) {
                    if (ori.toString().includes("*")) {
                        val *= Number(ori.replace(/\*/g, ""));
                    } else {
                        val += ori;
                    }
                }
            }
            sols.push({ val:val, header:header, easing:easing, easingRate:easingRate, extra:extra, num:num, datas:datas });
        });
        return sols;
    };
    
    

    //==================================================
    //--  イージング /ベーシック
    //==================================================

    //- イージングの適用
    function applyEasing(current, start, target, duration, timeMax, easing, easingRate = 1) {
        // イージングの処理
        if (easing.match(/ei|eo|e|en/i)) {
            return processEasing(current, target, duration + 1, timeMax, easing, easingRate);
        }
        // カービング
        if (easing.match(/tn|cg|fk|cf|rd|bk/i)) {
            return processCurving(current, start, target, duration + 1, timeMax, easing, easingRate);
        }
    };
    
    
    //- イージングの処理
    function processEasing(current, target, duration, timeMax, easing, easingRate = 1) {
        const lt = calcEasing((timeMax - duration) / timeMax, easing, easingRate);
        const t = calcEasing((timeMax - duration + 1) / timeMax, easing, easingRate);
        const start = (current - target * lt) / (1 - lt);
        return start + (target - start) * t;
    };
    
    
    //- イージングの計算
    function calcEasing(t, easing, easingRate = 1) {
        const exponent = 2 * easingRate;
        switch (easing.toUpperCase()) {
            case "EI":
                return easeIn(t, exponent);
            case "EO":
                return easeOut(t, exponent);
            case "E":
                return easeInOut(t, exponent);
            case "EN":
                return t;
            default:
                return t;
        }
    };
    
    
    //- 各イージング処理
    function easeIn(t, exponent) {
        return Math.pow(t, exponent) || 0.001;
    };
    
    function easeOut(t, exponent) {;
        return 1 - (Math.pow(1 - t, exponent) || 0.001);
    };
    
    function easeInOut(t, exponent) {
        if (t < 0.5) {
            return easeIn(t * 2, exponent) / 2;
        } else {
            return easeOut(t * 2 - 1, exponent) / 2 + 0.5;
        }
    };
    
    
    //- カービングの処理
    function processCurving(current, start, target, duration, timeMax, easing, easingRate = 1) {
        // 0 の時の処理
        if (duration <= 0) { return easing.match(/tn|rd|bk/i) ? start : target; }
        let result = 0;
        // ターン
        if (easing.toUpperCase() == "TN") {
            result = processTurn(current, start, target, duration, timeMax, easingRate);
        // チャージ
        } else if (easing.toUpperCase() == "CG") {
            result = processCharge(current, start, target, duration, timeMax, easingRate);
        // フック
        } else if (easing.toUpperCase() == "FK") {
            result = processFook(current, start, target, duration, timeMax, easingRate);
        // チャージフック
        } else if (easing.toUpperCase() == "CF") {
            result = processChargeFook(current, start, target, duration, timeMax, easingRate);
        // ラウンド
        } else if (easing.toUpperCase() == "RD") {
            result = processRound(current, start, target, duration, timeMax, easingRate);
        // バック
        }  else if (easing.toUpperCase() == "BK") {
            result = processBack(current, start, target, duration, timeMax, easingRate);
        }
        return result;
    };
    
    
    //- ターンの処理
    function processTurn(current, start, target, duration, timeMax, easingRate) {
        let result = 0;
        const d1 = Math.round(timeMax / 2);
        const d2 = timeMax - d1;
        if (duration > d2) {
            result = processEasing(current, target, duration - d2, d1, "e", easingRate);
        } else {
            result = processEasing(current, start, duration, d2, "e", easingRate);
        }
        return result;
    };
    
    
    //- チャージの処理
    function processCharge(current, start, target, duration, timeMax, easingRate) {
        let result = 0;
        const d1 = Math.round(timeMax / 3);
        const d2 = timeMax - d1;
        if (duration > d2) {
            result = processEasing(current, start + (start - target) * easingRate, duration - d2, d1, "e");
        } else {
            result = processEasing(current, target, duration, d2, "e");
        }
        return result;
    };
    
    
    //- フックの処理
    function processFook(current, start, target, duration, timeMax, easingRate) {
        let result = 0;
        const d1 = Math.round(timeMax * 2 / 3);
        const d2 = timeMax - d1;
        if (duration > d2) {
            result = processEasing(current, target + (target - start) * easingRate, duration - d2, d1, "e");
        } else {
            result = processEasing(current, target, duration, d2, "e");
        }
        return result;
    };
    
    
    //- チャージフックの処理
    function processChargeFook(current, start, target, duration, timeMax, easingRate) {
        let result = 0;
        const d1 = Math.round(timeMax / 4);
        const d3 = Math.round(timeMax / 4);
        const d2 = timeMax - d1 - d3;
        if (duration > (d2 + d3)) {
            result = processEasing(current, start + (start - target) * easingRate, duration - d2 - d3, d1, "e");
        } else if (duration > d3) {
            result = processEasing(current, target + (target - start) * easingRate, duration - d3, d2, "e");
        } else {
            result = processEasing(current, target, duration, d3, "e");
        }
        return result;
    };
    
    
    //- ラウンドの処理
    function processRound(current, start, target, duration, timeMax, easingRate) {
        let result = 0;
        const d1 = Math.round(timeMax / 4);
        const d2 = Math.round(timeMax / 2);
        const d3 = timeMax - d1 - d2;
        if (duration > (d2 + d3)) {
            result = processEasing(current, target, duration - d2 - d3, d1, "eo");
        } else if (duration > d3) {
            result = processEasing(current, start + (start - target) * easingRate, duration - d3, d2, "e");
        } else {
            result = processEasing(current, start, duration, d3, "ei");
        }
        return result;
    };
    
    
    //- バックの処理
    function processBack(current, start, target, duration, timeMax, easingRate) {
        let result = 0;
        const d1 = 1;
        const d2 = timeMax - d1;
        if (duration > d2) {
            result = processEasing(current, target, duration - d2, d1, "e", easingRate);
        } else {
            result = processEasing(current, start, duration, d2, "e", easingRate);
        }
        return result;
    };
    
    
    
    //==================================================
    //--  文字列基本 /ベーシック
    //==================================================
    
    //- 変数の置換
    function convertVariable(str, convert = "") {
        if (!str) { return str; }
        str = str.toString();
        const matches = str.match(/[\x1b\\]v\[(\d+)\]/gi);
        if (matches) {
            matches.forEach(parts => {
                const match = parts.match(/\\[vV]\[(\d+)\]/);
                const id = Number(match[1]);
                const val = $gameVariables.value(id);
                str = str.replace(match[0], val);
            });
        }
        if (str != null) {
            if (convert.match(/number/i)) { str = Number(str); }
            if (convert.match(/boolean/i)) { str = toBoolean(str); }
        }
        return str;
    };


    //- 文字列の数字リスト化
    function strToNumList(str) {
        const list = [];
        str = str.replace(/\[/g, "");
        str = str.replace(/\]/g, "");
        const strs = str.split(",");
        let s2 = null;
        for (let s of strs) {
            if (s.includes("~")) {
                s2 = s.split("~");
                s2 = s2.map(s => Number(s));
                if (s2[1] >= s2[0]) {
                    for (let i = s2[0]; i <= s2[1]; i++) { list.push(i); }
                } else {
                    for (let i = s2[1]; i <= s2[0]; i++) { list.push(i); }
                }
            } else {
                list.push(Number(s));
            }
        };
        return list;
    };
    
    
    
    //==================================================
    //--  プラグインコマンド基本 /ベーシック
    //==================================================
    
    let plcmPreter = null;
    
    //- プラグインコマンド呼び出しプリターを保存
    const _PluginManager_callCommand = PluginManager.callCommand;
    PluginManager.callCommand = function(self, pluginName, commandName, args) {
        plcmPreter = self;
        _PluginManager_callCommand.apply(this, arguments);
        plcmPreter = null;
    };
    
    
    //- プラグインコマンド呼び出しイベントを取得
    function getPlcmEvent() {
        if (!plcmPreter) { return; }
        const preter = plcmPreter;
        return preter.character(preter.eventId());
    };
    
    //- 名前でのキャラリスト取得
    function getCharasByName(names, self) {
        if (!names) { return []; }
        const nameList = names.replace(/\s/g, "").split(",");
        let charas = [];
        let match = null;
        for (const name of nameList) {
            // イベントを取得
            $gameMap.events().forEach(event => {
                const note = event.event().name + " " + event.event().note;
                if (note.includes(name)) { charas.push(event); }
            });
            // セルフを取得
            if (name.match(/^(セルフ|自分|自身|self)$/)) {
                self = self || getPlcmEvent() || charaSpritePlcm._character;
                if (self) { charas.push(self); }
            }
            // プレイヤーを取得
            if (name.match(/^(プレイヤー|操作キャラ|player)$/)) {
                charas = [...charas, $gamePlayer];
            }
            // フォロワーを取得
            match = name.match(/^(フォロワー|フォロアー|隊列|隊列キャラ|follower)(\d*)$/)
            if (match) {
                const id = match[2] ? Number(match[2]) - 1 : 0;
                charas = id != null ? [...charas, $gamePlayer._followers._data[id]] : [...charas, ...$gamePlayer._followers._data];
            }
            // パーティを取得
            if (name.match(/^(パーティ|味方|味方全員|味方全体|party)$/)) {
                charas = [...charas, $gamePlayer, ...$gamePlayer._followers._data];
            }
            // 乗り物を取得
            match = name.match(/^(乗り物|乗物|乗機|vehicle)(\d*)$/);
            if (match) {
                const id = match[2] ? Number(match[2]) - 1 : 0;
                charas = id ? [...charas, $gameMap._vehicles[id]] : [...charas, ...$gameMap._vehicles];
            }
            // 全て取得
            if (name.match(/^(全て|すべて|全部|全体|all)$/)) {
                charas = [...$gameMap.events(), $gamePlayer, ...$gamePlayer._followers._data, ...$gameMap._vehicles];
            }
            // 選択なし
            if (name.match(/^(なし|無し|none)$/)) {
            }
        }
        charas = charas.filter(chara => chara);
        return charas;
    };
    
    
    //- IDでのキャラリスト取得
    function getCharasById(ids, self) {
        if (!ids) { return []; }
        const idList = !ids ? [] : strToNumList(ids.toString());
        let charas = [];
        for (const id of idList) {
            // イベントを取得
            if (id > 0) { charas.push($gameMap.event(id)); }
            // セルフを取得
            if (id == 0) {
                self = self || getPlcmEvent() || charaSpritePlcm._character;
                if (self && !idList.includes(self._eventId)) { charas.push(self); }
            }
            // プレイヤーを取得
            if (id == -1) { charas = [...charas, $gamePlayer]; }
            // フォロワーを取得
            if (id <= -10 && id >= -99) {
                charas = id == -10 ? [...charas, ...$gamePlayer._followers._data] : [...charas, $gamePlayer._followers._data[Math.abs(id) - 11]];
            }
            // 乗り物を取得
            if (id <= -100) {
                charas = id == -100 ? [...charas, ...$gameMap._vehicles] : [...charas, $gameMap._vehicles[Math.abs(id) - 101]];
            }
            // 全て取得
            if (id == -2) {
                charas = [...$gameMap.events(), $gamePlayer, ...$gamePlayer._followers._data, ...$gameMap._vehicles];
            }
        }
        charas = charas.filter(chara => chara);
        return charas;
    };
    
    
    //- 全てのキャラを取得
    function getAllCharacter() {
        return  [...$gameMap.events(), $gamePlayer, ...$gamePlayer._followers._data, ...$gameMap._vehicles];
    };
    
    
    //- 名前でのバトラーリスト取得
    function getBattlersByName(names, target) {
        if (!names) { return []; }
        const nameList = names.replace(/\s/g, "").split(",");
        let members = [];
        if (!target || target.includes("actor")) {
            members = [...members, ...$gameParty.members()];
        }
        if (!target || target.includes("enemy")) {
            members = [...members, ...$gameTroop.members()];
        }
        let battlers = [];
        for (const name of nameList) {
            // メンバーを取得
            members.forEach(battler => {
                if (battler.name().includes(name)) {
                    battlers.push(battler);
                }
            });
            // パーティを取得
            if (name.match(/^(パーティ|アクター|味方|味方全員|味方全体|party)$/)) {
                battlers = [...$gameParty.members()];
            }
            // 敵パーティを取得
            if (name.match(/^(敵パーティ|敵軍|トループ|敵|敵全員|敵全体|troop)$/)) {
                battlers = [...$gameTroop.members()];
            }
            // 全て取得
            if (name.match(/^(全て|すべて|全部|全体|all)$/)) {
                battlers = members;
                break;
            }
            // 選択なし
            if (name.match(/^(なし|無し|none)$/)) {
                break;
            }
        }
        battlers = battlers.filter(battler => battler);
        return battlers;
    };
    
    
    //- IDでのバトラーリスト取得
    function getBattlersById(ids, target) {
        if (!ids) { return []; }
        const idList = !ids ? [] : strToNumList(ids);
        let members = [];
        if (!targets || target.includes("actor")) {
            members = [...members, ...$gameParty.members()];
        }
        if (!target || target.includes("enemy")) {
            members = [...members, ...$gameTroop.members()];
        }
        let battlers = [];
        for (const id of idList) {
            // IDで対象取得
            if (id > 0) { battlers = [...battlers, ...members.filter(battler => battler._battlerId == id)]; }
            // 全て取得
            if (id == -2) {
                battlers = members;
                break;
            }
        }
        battlers = battlers.filter(battler => battler);
        return battlers;
    };
    
    
    //- インデックスでのバトラーリスト取得
    function getBattlersByIndex(indexs, target) {
        if (!indexs) { return []; }
        const indexList = !indexs ? [] : strToNumList(indexs);
        let members = [];
        if (!target || target.includes("actor")) {
            members = [...members, ...$gameParty.members()];
        }
        if (!target || target.includes("enemy")) {
            members = [...members, ...$gameTroop.members()];
        }
        let battlers = [];
        for (const index of indexList) {
            // インデックスで対象取得
            if (index > 0) { battlers.push(members[index - 1]); }
            // 全て取得
            if (index == -2) {
                battlers = members;
                break;
            }
        }
        battlers = battlers.filter(battler => battler);
        return battlers;
    };
    
    
    
    //==================================================
    //--  配列基本 /ベーシック
    //==================================================
    
    //- ハッシュのディープコピー
    function copyHash(hash) {
        const copy = {};
        Object.keys(hash).forEach(k => {
            if (hash[k].constructor.name == "Object") {
                copy[k] = copyHash(hash[k]);
            } else if (hash[k].constructor.name == "Array") {
                copy[k] = copyArray(hash[k]);
            } else {
                copy[k] = hash[k];
            }
        });
        return copy;
    };
    
    
    //- 配列のディープコピー
    function copyArray(array) {
        const copy = [];
        array.forEach((v, i) => {
            if (v.constructor.name == "Object") {
                copy[i] = copyHash(v);
            } else if (v.constructor.name == "Array") {
                copy[i] = copyArray(v);
            } else {
                copy[i] = v;
            }
        });
        return copy;
    };
    
    
    
    //==================================================
    //--  スプライト基本 /ベーシック
    //==================================================
    
    //- スプライトの検索
    function searchSprite(subject) {
        let sprite = null;
        if (!$gameParty.inBattle()) {
            sprite = searchSpriteChara(subject);
        } else {
            sprite = searchSpriteBattler(subject);
        }
        return sprite;
    };
    
    
    //- スプライトの検索-キャラクター
    function searchSpriteChara(chara) {
        let result = null;
        const sprites = SceneManager._scene._spriteset._characterSprites;
        for (let sprite of sprites) {
            if (isSameChara(sprite._character, chara)) {
                result = sprite;
                break;
            }
        }
        return result;
    };
    
    
    //- スプライトの検索-バトラー
    function searchSpriteBattler(battler) {
        const spriteset = SceneManager._scene._spriteset;
        let result = null;
        const sprites = battler._enemyId ? spriteset._enemySprites : spriteset._actorSprites;
        for (const sprite of sprites) {
            if(!sprite._battler) { continue; }
            if ((battler._actorId && sprite._battler._actorId == battler._actorId) || (battler._enemyId && sprite._battler.index() == battler.index())) {
                result = sprite;
                break;
            }
        }
        return result;
    };
    
    
    //- 同じキャラか
    function isSameChara(a, b) {
        if (!a) { return !b; }
        if (!b) { return !a; }
        if (a._eventId) {
            if (!b._eventId) { return false; }
            return a._eventId == b._eventId;
        }
        if (a._followers && b._followers) { return true; }
        if (a._memberIndex && a._memberIndex == b._memberIndex) { return true; }
        if (a._type && a._type == b._type) { return true; }
        return false;
    };
    
    
    
    //==================================================
    //---  位置基本 /ベーシック
    //==================================================
    
    //- スクリーンX
    function screenX(x, anchor = 0.5) {
        const tw = $gameMap.tileWidth();
        return Math.floor($gameMap.adjustX(x) * tw + tw * anchor);
    };
    
    
    //- スクリーンY
    function screenY(y, anchor = 0.5) {
         const th = $gameMap.tileHeight();
        return Math.floor( $gameMap.adjustY(y) * th + th * anchor);
    };
    
    
    //- 画面X座標をマップX座標へ
    function canvasToMapX(x) {
        const gm = $gameMap;
        const tileWidth = gm.tileWidth();
        const originX = gm._displayX * tileWidth;
        const mapX = (originX + x) / tileWidth;
        return gm.roundX(mapX);
    };
    
    
    //- 画面X座標をマップX座標へ
    function canvasToMapY(y) {
        const gm = $gameMap;
        const tileHeight = gm.tileHeight();
        const originY = gm._displayY * tileHeight;
        const mapY = (originY + y) / tileHeight;
        return gm.roundY(mapY);
    };
    
    
    
    //==================================================
    //--  メタ配列 /ベーシック
    //==================================================
     
    // 全てのメタ配列を合算
    function totalAllMetaArray(battler, words, action) {
        // イニット
        let data = null
        let array = [];
        // バトラー値
        data = battler.actorId ? battler.actor() : battler.enemy();
        if (data) { metaAll(data.note, words).forEach(e => array.push(e)); }
        if (battler._actorId) {
            // 職業値
            data = battler.currentClass();
            if (data) { metaAll(data.note, words).forEach(e => array.push(e)); }
            // 装備値
            battler._equips.forEach(equip => {
                data = equip.object();
                if (data) { metaAll(data.note, words).forEach(e => array.push(e)); }
            });
        }
        // ステート値
        battler._states.forEach(stateId => {
            data = $dataStates[stateId];
            if (data) { metaAll(data.note, words).forEach(e => array.push(e)); }
        }, battler);
        // アクション値
        if (action) {
            data = action.item();
            if (data) { metaAll(data.note, words).forEach(e => array.push(e)); }
        }
        // スペース削除
        array = array.map(e => e.replace(/\s/g, ""));
        // 空の要素は削除
        array = array.filter(e => e);
        return array;
    };
    
    
   //- 全取得メタ
    function metaAll(note, words) {
        var result = [];
        words.forEach(word => {
            var regText = '\<' + word + ':([^\>]*)\>';
            var regExp_g = new RegExp(regText, 'gi');
            var regExp = new RegExp(regText, 'i');
            var matches = note.match(regExp_g);
            var match = null;
            if (matches) {
                matches.forEach(function(line) {
                    result.push(line.match(regExp)[1]);
                });
            }
        });
        return result;
    };
    
})();